<?php
require 'auth_check.php';
require 'db_connect.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $address = trim($_POST['address']) ?: null;
    $city = trim($_POST['city']) ?: null;
    $state = trim($_POST['state']) ?: null;
    $postcode = trim($_POST['postcode']) ?: null;
    $country = trim($_POST['country']) ?: null;

    if (empty($name) || empty($email) || empty($phone)) {
        header("Location: customers.php?error=required_fields_missing");
        exit();
    }

    try {
        // Check if customer email already exists for this user
        $stmt_check = $pdo->prepare("SELECT id FROM transactions WHERE user_id = ? AND customer_email = ?");
        $stmt_check->execute([$user_id, $email]);
        if ($stmt_check->fetch()) {
            header("Location: customers.php?error=email_exists");
            exit();
        }

        // Insert into transactions table with new columns
        $sql = "INSERT INTO transactions (user_id, unique_id, amount, customer_name, customer_email, phone, address, city, state, postcode, country, status, meta_data) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt_insert = $pdo->prepare($sql);
        $stmt_insert->execute([
            $user_id,
            'manual_' . sha1(uniqid(rand(), true)),
            0, // Amount is 0 for manually added customers
            $name,
            $email,
            $phone,
            $address,
            $city,
            $state,
            $postcode,
            $country,
            'completed', // Status can be set as needed
            json_encode(['source' => 'manual_entry'])
        ]);

        header("Location: customers.php?success=customer_added");
        exit();

    } catch (PDOException $e) {
        error_log("Error adding customer: " . $e->getMessage());
        header("Location: customers.php?error=database_error");
        exit();
    }
} else {
    header("Location: customers.php");
    exit();
}
