<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) { http_response_code(401); die(json_encode(['success' => false, 'message' => 'API Key is missing.'])); }
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) { http_response_code(403); die(json_encode(['success' => false, 'message' => 'Invalid API Key.'])); }

$user_id = $setting['user_id'];
$email = $_POST['email'] ?? null;

if ($email) {
    try {
        $sql = "DELETE FROM transactions WHERE user_id = :user_id AND customer_email = :email";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([':user_id' => $user_id, ':email' => $email]);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Customer deleted successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Customer not found.']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database error.']);
    }
} else {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Email not provided.']);
}
?>