<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

$customers = [];

try {
    // শুধুমাত্র সর্বশেষ তথ্য দিয়ে ইউনিক গ্রাহকদের তালিকা তৈরি করা
    $sql = "
        SELECT 
            t1.customer_name, 
            t1.customer_email,
            t1.phone,
            t1.address,
            t1.city,
            t1.state,
            t1.postcode,
            t1.country
        FROM transactions t1
        INNER JOIN (
            SELECT customer_email, MAX(id) as max_id
            FROM transactions
            WHERE user_id = :user_id AND customer_email IS NOT NULL AND customer_email != ''
            GROUP BY customer_email
        ) t2 ON t1.id = t2.max_id AND t1.customer_email = t2.customer_email
        ORDER BY t1.id DESC
    ";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':user_id' => $user_id]);
    $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['success' => true, 'customers' => $customers]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>