<?php
require 'auth_check.php';
require 'db_connect.php';

// Fetch the user's current balance
$stmt = $pdo->prepare("SELECT balance, email FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$current_balance = $user['balance'] ?? '0.00'; // স্ট্রিং হিসেবে রাখা ভালো
$_SESSION['user_email'] = $user['email']; // Store email in session for initiate_funding.php

// === Credit Calculation Logic ===
$user_id = $_SESSION['user_id'];
// ★★★ পরিবর্তন: রেটটিকে জাভাস্ক্রিপ্টে ব্যবহারের জন্য স্ট্রিং হিসেবে ডিফাইন করা হয়েছে ★★★
define('USD_TO_BDT_RATE', '120'); 

// ★★★ সমাধান: শুধুমাত্র ব্যালেন্স থেকে কেনা ক্রেডিটগুলো গণনা করা হচ্ছে ★★★
$stmt_purchased = $pdo->prepare("SELECT SUM(amount_bdt) as total_purchased FROM user_funds WHERE user_id = ? AND status = 'completed' AND transaction_unique_id LIKE 'manual_purchase_%'");
$stmt_purchased->execute([$user_id]);
$purchased_result = $stmt_purchased->fetch(PDO::FETCH_ASSOC);
$purchased_credits = $purchased_result['total_purchased'] ?? 0;

// 2. Define free credits for new accounts
$free_credits = 50;

// 3. Calculate total available credits
$total_credits = $free_credits + $purchased_credits;

// 4. Get total used credits (each record in credit_transactions is 1 credit)
$stmt_used = $pdo->prepare("SELECT COUNT(id) as total_used FROM credit_transactions WHERE user_id = ?");
$stmt_used->execute([$user_id]);
$used_result = $stmt_used->fetch(PDO::FETCH_ASSOC);
$used_credits = $used_result['total_used'] ?? 0;

// 5. Calculate remaining credits and usage percentage
$remaining_credits = $total_credits - $used_credits;
$usage_percentage = ($total_credits > 0) ? ($used_credits / $total_credits) * 100 : 0;
// === End of Credit Calculation ===


include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <div class="billing-container">
        <aside class="billing-sidebar">
            <nav>
                <ul>
                    <li class="active"><a href="billing.php">Billing</a></li>
                    <li><a href="billing_history.php">Billing Histories</a></li>
                </ul>
            </nav>
        </aside>
        <main class="billing-main">
            <div class="billing-content-grid">
                <div class="account-balance">
                    <h3>Account Balance</h3>
                    <p class="balance"><?php echo number_format((float)$current_balance, 2); ?> USD</p>
                    <p class="availability">Available for Purchasing Credits</p>
                    <button class="btn btn-primary" id="addFundsBtn">+ Add Funds</button>
                </div>
                <div class="plan-quota">
                    <h3>Plan quota</h3>
                    <div class="quota-item">
                        <div class="quota-info">
                            <span>Payments</span>
                            <span><?php echo number_format($used_credits); ?> / <?php echo number_format($total_credits); ?> (<?php echo number_format($usage_percentage, 0); ?>%)</span>
                        </div>
                        <div class="quota-bar">
                            <div class="quota-progress" style="width: <?php echo number_format($usage_percentage, 2); ?>%;"></div>
                        </div>
                        <div class="plan-allocation">
                            <p>Plan Allocation</p>
                            <ul>
                                <li>Used: <span><?php echo number_format($used_credits); ?> / <?php echo number_format($total_credits); ?></span></li>
                                <li>Remaining: <span><?php echo number_format($remaining_credits); ?></span></li>
                                <li>Reset date: <span>Jul 29, 2025</span></li>
                            </ul>
                        </div>
                    </div>
                    <button class="btn btn-secondary" id="purchaseCreditsBtn" style="margin-top: 15px;">+ Purchase Credits</button>
                </div>
            </div>
        </main>
    </div>
</div>

<!-- Add Funds Modal -->
<div id="addFundsModal" class="billing-modal-overlay">
    <div class="billing-modal-content">
        <div class="billing-modal-header">
            <h2>Add Funds</h2>
            <button class="close-modal-btn">&times;</button>
        </div>
        <div class="billing-modal-body">
            <form id="addFundsForm">
                <div class="form-group">
                    <label>Choose the amount<span class="required-star">*</span></label>
                    <div class="amount-grid">
                        <button type="button" class="amount-btn" data-amount="10">10 USD</button>
                        <button type="button" class="amount-btn active" data-amount="25">25 USD</button>
                        <button type="button" class="amount-btn" data-amount="50">50 USD</button>
                        <button type="button" class="amount-btn" data-amount="100">100 USD</button>
                        <button type="button" class="amount-btn" data-amount="250">250 USD</button>
                        <button type="button" class="amount-btn" data-amount="500">500 USD</button>
                        <button type="button" class="amount-btn" data-amount="1000">1000 USD</button>
                        <button type="button" class="amount-btn" data-amount="2000">2000 USD</button>
                        <button type="button" class="amount-btn" id="customAmountBtn">Custom</button>
                    </div>
                    <div class="form-group" id="customAmountInputContainer" style="display: none; margin-top: 15px;">
                        <input type="number" step="0.01" name="custom_amount" id="custom_amount_input" placeholder="Enter custom amount">
                    </div>
                </div>
            </form>
        </div>
        <div class="billing-modal-footer">
            <button type="button" class="btn btn-primary" id="submitFundsBtn">Submit</button>
            <button type="button" class="btn btn-secondary cancel-modal-btn">Cancel</button>
        </div>
    </div>
</div>

<!-- Purchase Credits Modal -->
<div id="purchaseCreditsModal" class="billing-modal-overlay">
    <div class="billing-modal-content" style="max-width: 550px;">
        <div class="billing-modal-header">
            <h2>Purchase Credits from Balance</h2>
            <button class="close-modal-btn">&times;</button>
        </div>
        <div class="billing-modal-body">
            <p style="margin-top:0;">Your current balance: <strong id="modal-current-balance">$<?php echo number_format((float)$current_balance, 2); ?> USD</strong></p>
            <div class="form-group">
                <label for="credit-amount-input">Number of Credits (1 Credit = 1 BDT)</label>
                <input type="number" id="credit-amount-input" name="credit_amount" placeholder="e.g., 100" min="1">
            </div>
            <div class="amount-grid" style="grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));">
                <button type="button" class="amount-btn credit-preset" data-credits="100">100</button>
                <button type="button" class="amount-btn credit-preset" data-credits="200">200</button>
                <button type="button" class="amount-btn credit-preset" data-credits="500">500</button>
                <button type="button" class="amount-btn credit-preset" data-credits="1000">1000</button>
            </div>
            <div id="purchase-summary" style="margin-top: 20px; padding: 15px; background-color: #f8f9fa; border-radius: 8px; text-align: center;">
                Cost: <strong id="purchase-cost-display">$0.00 USD</strong>
                <p id="insufficient-balance-warning" style="color: #dc3545; display: none; margin-top: 5px;">Insufficient balance</p>
            </div>
        </div>
        <div class="billing-modal-footer">
            <button type="button" class="btn btn-primary" id="confirmPurchaseBtn">Confirm Purchase</button>
            <button type="button" class="btn btn-secondary cancel-modal-btn">Cancel</button>
        </div>
    </div>
</div>

<div id="toast-notification"></div>

</div> 
<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // --- Shared Toast Function ---
    function showToast(message, isSuccess) {
        const toast = document.getElementById('toast-notification');
        if (!toast) return;
        toast.textContent = message;
        toast.className = 'show ' + (isSuccess ? 'success' : 'error');
        setTimeout(() => { toast.className = toast.className.replace('show', ''); }, 3000);
    }

    // --- Add Funds Modal Logic ---
    const addFundsBtn = document.getElementById('addFundsBtn');
    const addFundsModal = document.getElementById('addFundsModal');
    if (addFundsModal && addFundsBtn) {
        const closeModalBtns = addFundsModal.querySelectorAll('.close-modal-btn, .cancel-modal-btn');
        const submitFundsBtn = document.getElementById('submitFundsBtn');
        const amountBtns = addFundsModal.querySelectorAll('.amount-btn');
        const customAmountInputContainer = document.getElementById('customAmountInputContainer');
        const customAmountInput = document.getElementById('custom_amount_input');
        
        const openModal = () => addFundsModal.classList.add('open');
        const closeModal = () => addFundsModal.classList.remove('open');

        addFundsBtn.addEventListener('click', openModal);
        closeModalBtns.forEach(btn => btn.addEventListener('click', closeModal));
        addFundsModal.addEventListener('click', (e) => { if (e.target === addFundsModal) closeModal(); });

        amountBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                amountBtns.forEach(b => b.classList.remove('active'));
                this.classList.add('active');
                customAmountInput.value = '';
                if (this.id === 'customAmountBtn') {
                    customAmountInputContainer.style.display = 'block';
                } else {
                    customAmountInputContainer.style.display = 'none';
                }
            });
        });

        if(submitFundsBtn){
            submitFundsBtn.addEventListener('click', function() {
                let finalAmount = 0;
                const activeAmountBtn = addFundsModal.querySelector('.amount-btn.active');
                if (activeAmountBtn && activeAmountBtn.id !== 'customAmountBtn') {
                    finalAmount = parseFloat(activeAmountBtn.dataset.amount);
                } else {
                    finalAmount = parseFloat(customAmountInput.value);
                }

                if (!finalAmount || finalAmount <= 0) {
                    showToast('Please select or enter a valid amount.', false); return;
                }
                this.disabled = true; this.innerText = 'Processing...';
                fetch('initiate_funding.php', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ amount: finalAmount })})
                .then(response => response.json()).then(data => {
                    if (data.success && data.payment_url) { window.location.href = data.payment_url; } 
                    else { showToast(data.message || 'Could not initiate payment.', false); this.disabled = false; this.innerText = 'Submit'; }
                }).catch(() => { showToast('A network error occurred.', false); this.disabled = false; this.innerText = 'Submit'; });
            });
        }
    }
    
    // --- Purchase Credits Modal Logic ---
    const purchaseCreditsBtn = document.getElementById('purchaseCreditsBtn');
    const purchaseModal = document.getElementById('purchaseCreditsModal');
    if (purchaseCreditsBtn && purchaseModal) {
        const closePurchaseModalBtns = purchaseModal.querySelectorAll('.close-modal-btn, .cancel-modal-btn');
        const creditInput = document.getElementById('credit-amount-input');
        const costDisplay = document.getElementById('purchase-cost-display');
        const warningText = document.getElementById('insufficient-balance-warning');
        const confirmBtn = document.getElementById('confirmPurchaseBtn');
        const creditPresetBtns = purchaseModal.querySelectorAll('.credit-preset');

        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ★★★    JavaScript-এ নির্ভুল হিসাবের জন্য পরিবর্তন   ★★★
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        const userBalance = parseFloat('<?php echo $current_balance; ?>');
        const usdToBdtRate = parseFloat('<?php echo USD_TO_BDT_RATE; ?>'); // সরাসরি মূল রেট ব্যবহার করা হচ্ছে

        const openPurchaseModal = () => purchaseModal.classList.add('open');
        const closePurchaseModal = () => {
             purchaseModal.classList.remove('open');
             creditInput.value = '';
             updateCost();
        };
        
        purchaseCreditsBtn.addEventListener('click', openPurchaseModal);
        closePurchaseModalBtns.forEach(btn => btn.addEventListener('click', closePurchaseModal));
        purchaseModal.addEventListener('click', (e) => { if (e.target === purchaseModal) closePurchaseModal(); });

        const updateCost = () => {
            const credits = parseInt(creditInput.value) || 0;
            if (credits <= 0) {
                costDisplay.textContent = '$0.00 USD';
                warningText.style.display = 'none';
                confirmBtn.disabled = true;
                return;
            }
            
            // গুণ করার পরিবর্তে মূল রেট দিয়ে ভাগ করা হয়েছে, যা নির্ভুলতা বাড়ায়
            const cost = credits / usdToBdtRate; 
            costDisplay.textContent = `$${cost.toFixed(4)} USD`; // দশমিকের পর ৪ ঘর দেখানো হচ্ছে

            if (cost > userBalance) {
                warningText.style.display = 'block';
                confirmBtn.disabled = true;
            } else {
                warningText.style.display = 'none';
                confirmBtn.disabled = false;
            }
        };
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

        creditInput.addEventListener('input', updateCost);
        
        creditPresetBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                creditInput.value = this.dataset.credits;
                updateCost();
            });
        });

        confirmBtn.addEventListener('click', function() {
            const creditsToBuy = parseInt(creditInput.value);
            if (!creditsToBuy || creditsToBuy <= 0) {
                showToast('Please enter a valid number of credits.', false);
                return;
            }
            this.disabled = true;
            this.innerText = 'Processing...';

            fetch('api/purchase_credits.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ credits: creditsToBuy })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    showToast('Credits purchased successfully! Page will reload.', true);
                    setTimeout(() => window.location.reload(), 2000);
                } else {
                    showToast(data.message || 'Purchase failed.', false);
                    this.disabled = false;
                    this.innerText = 'Confirm Purchase';
                }
            })
            .catch(err => {
                 showToast('An error occurred. Please try again.', false);
                 this.disabled = false;
                 this.innerText = 'Confirm Purchase';
            });
        });
        
        updateCost(); // Initial call to set button state
    }

    // --- Handle Return from Checkout ---
    const urlParams = new URLSearchParams(window.location.search);
    const fundingStatus = urlParams.get('funding_status');
    const trxId = urlParams.get('trx_id');
    if (fundingStatus === 'success' && trxId) {
        fetch('verify_funding.php', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({ trx_id: trxId })})
        .then(response => response.json()).then(data => {
            if (data.success) { showToast('Funds added successfully! Reloading...', true); setTimeout(() => window.location.href = 'billing.php', 2000); } 
            else { showToast(data.message || 'Funding verification failed.', false); }
        });
    } else if (fundingStatus === 'cancelled') {
        showToast('The funding process was cancelled.', false);
    }
});
</script>
</body>
</html>