<?php
require 'auth_check.php';
require 'db_connect.php';

$user_id = $_SESSION['user_id'];
$success_message = '';
$error_message = ''; // ★★★ এরর বার্তা সংরক্ষণের জন্য নতুন ভ্যারিয়েবল
$upload_dir = "uploads/logos/{$user_id}/";

// ★★★ এরর বার্তা URL থেকে গ্রহণ করা হচ্ছে ★★★
if (isset($_GET['error'])) {
    $error_message = htmlspecialchars($_GET['error']);
}
if (isset($_GET['success'])) {
    $success_message = "Logos have been updated successfully!";
}

// ডেটাবেস থেকে বর্তমান লোগো গুলো আনা হচ্ছে
$stmt_fetch = $pdo->prepare("SELECT * FROM brand_logos WHERE user_id = ?");
$stmt_fetch->execute([$user_id]);
$current_logos = $stmt_fetch->fetch(PDO::FETCH_ASSOC);

// ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
// ★★★      Fileinfo ব্যবহার করে নতুন এবং সুরক্ষিত handle_upload ফাংশন     ★★★
// ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
function handle_upload($file_key, $upload_dir, $current_file_path) {
    // অনুমোদিত এক্সটেনশন এবং MIME Type-এর তালিকা
    $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'ico', 'svg'];
    $allowed_mime_types = ['image/jpeg', 'image/png', 'image/gif', 'image/x-icon', 'image/svg+xml'];

    // যদি ছবি ডিলিট করার জন্য অনুরোধ আসে
    if (!empty($_POST['remove_' . $file_key]) && $_POST['remove_' . $file_key] === '1') {
        if ($current_file_path && file_exists($current_file_path)) {
            unlink($current_file_path);
        }
        return ['path' => null, 'error' => null]; // সফলভাবে ডিলিট হয়েছে
    }

    // যদি নতুন ফাইল আপলোড করা হয়
    if (isset($_FILES[$file_key]) && $_FILES[$file_key]['error'] === UPLOAD_ERR_OK) {
        $file = $_FILES[$file_key];
        
        // ১. ফাইলের এক্সটেনশন পরীক্ষা করা
        $file_ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        if (!in_array($file_ext, $allowed_extensions)) {
            return ['path' => null, 'error' => 'Invalid file extension: .' . $file_ext];
        }

        // আপলোড ডিরেক্টরি তৈরি করা
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }
        
        $new_filename = uniqid($file_key . '_', true) . '.' . $file_ext;
        $destination = $upload_dir . $new_filename;
        
        // ফাইলটি সার্ভারে অস্থায়ীভাবে সরানো হচ্ছে
        if (move_uploaded_file($file['tmp_name'], $destination)) {
            // ২. Fileinfo দিয়ে ফাইলের আসল ধরন (MIME Type) পরীক্ষা করা
            $finfo = new finfo(FILEINFO_MIME_TYPE);
            $mime_type = $finfo->file($destination);

            if (in_array($mime_type, $allowed_mime_types)) {
                // ফাইলটি বৈধ হলে, পুরোনো ফাইল (যদি থাকে) ডিলিট করা হবে
                if ($current_file_path && file_exists($current_file_path)) {
                    unlink($current_file_path);
                }
                return ['path' => $destination, 'error' => null]; // সফলভাবে আপলোড হয়েছে
            } else {
                // ফাইলটি অবৈধ হলে, সার্ভার থেকে মুছে ফেলা হবে (সবচেয়ে গুরুত্বপূর্ণ ধাপ)
                unlink($destination);
                return ['path' => null, 'error' => 'Invalid file type detected: ' . $mime_type];
            }
        }
    }
    // কোনো পরিবর্তন না হলে পুরোনো পাথ ফেরত পাঠানো
    return ['path' => $current_file_path, 'error' => null];
}
// ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

// POST রিকোয়েস্ট হ্যান্ডেল করার জন্য আপডেট করা কোড
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $results = [];
    $has_error = false;
    
    // প্রতিটি ফাইল আপলোডের ফলাফল একটি অ্যারেতে সংরক্ষণ করা হচ্ছে
    $results['primary_logo'] = handle_upload('primary_logo', $upload_dir, $current_logos['primary_logo'] ?? null);
    $results['round_logo'] = handle_upload('round_logo', $upload_dir, $current_logos['round_logo'] ?? null);
    $results['favicon'] = handle_upload('favicon', $upload_dir, $current_logos['favicon'] ?? null);

    // কোনো একটি ফাইলে এরর আছে কিনা তা পরীক্ষা করা হচ্ছে
    foreach ($results as $result) {
        if ($result['error']) {
            $has_error = true;
            // যদি এরর থাকে, তাহলে ব্যবহারকারীকে এরর বার্তা সহ রিডাইরেক্ট করা হবে
            header("Location: brand_icon.php?error=" . urlencode($result['error']));
            exit();
        }
    }

    // যদি কোনো এরর না থাকে, তাহলে ডেটাবেসে পাথ সেভ করা হবে
    $sql = "INSERT INTO brand_logos (user_id, primary_logo, round_logo, favicon) VALUES (:user_id, :p_logo, :r_logo, :fav)
            ON DUPLICATE KEY UPDATE primary_logo = :p_logo, round_logo = :r_logo, favicon = :fav";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':user_id' => $user_id, 
        ':p_logo' => $results['primary_logo']['path'], 
        ':r_logo' => $results['round_logo']['path'], 
        ':fav' => $results['favicon']['path']
    ]);

    // সফলভাবে সেভ হওয়ার পর রিডাইরেক্ট করা হচ্ছে
    header("Location: brand_icon.php?success=1");
    exit();
}

include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <div class="page-header">
        <div><p class="breadcrumbs">Brand Settings > Brand Icon & Favicon</p><h1 class="page-title">Logo & Favicon</h1></div>
    </div>

    <div class="content-card">
        <form action="brand_icon.php" method="POST" enctype="multipart/form-data">
            <div class="settings-section" style="border-top: none; padding-top: 10px;">
                <h3>Logo & Favicon</h3><p>Configure the logos used throughout your application</p>
                <div class="logo-uploader-grid">
                    <?php
                    function render_uploader($name, $label, $tooltip, $current_path, $is_round = false, $size_text) {
                        $has_image = !empty($current_path);
                        $uploader_class = 'image-uploader' . ($is_round ? ' uploader-round' : '') . ($has_image ? ' has-preview' : '');
                        echo '<div class="form-group">';
                        echo '  <label class="label-with-tooltip">'.$label.($tooltip ? ' <i class="fas fa-question-circle"></i>' : '').'</label>';
                        echo '  <div class="'.$uploader_class.'" id="'.$name.'_uploader">';
                        echo '      <input type="file" name="'.$name.'" accept="image/*">';
                        echo '      <input type="hidden" name="remove_'.$name.'" value="">';
                        echo '      <div class="uploader-content">';
                        if ($has_image) {
                            echo '<div class="preview-container">';
                            echo '  <img src="'.htmlspecialchars($current_path).'?t='.time().'" alt="Preview" class="image-preview">';
                            echo '  <button type="button" class="remove-image-btn">&times;</button>';
                            echo '</div>';
                        } else {
                            echo '<div class="uploader-text">Drag & Drop your files or <span class="browse-link">Browse</span></div>';
                        }
                        echo '      </div>';
                        echo '  </div>';
                        echo '  <small>'.$size_text.'</small>';
                        echo '</div>';
                    }

                    render_uploader('primary_logo', 'Primary Logo', false, $current_logos['primary_logo'] ?? null, false, 'Main logo used in header and emails (48x48 recommended)');
                    render_uploader('round_logo', 'Round Logo', true, $current_logos['round_logo'] ?? null, true, 'Used for avatars and round logo displays (32x32 recommended)');
                    render_uploader('favicon', 'Favicon', true, $current_logos['favicon'] ?? null, true, 'Browser tab icon (32x32 recommended)');
                    ?>
                </div>
            </div>
            <div class="settings-actions"><button type="submit" class="btn btn-primary">Save changes</button></div>
        </form>
    </div>
</div>

</div> <!-- .main-content -->
<div id="toast-notification"></div>
<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // ★★★ Toast Notification ফাংশনটি এখন এররও দেখাতে পারবে ★★★
    function showToast(message, isSuccess) {
        const toast = document.getElementById('toast-notification');
        if (!toast) return;
        toast.textContent = message;
        // isSuccess প্যারামিটার অনুযায়ী 'success' বা 'error' ক্লাস যুক্ত হবে
        toast.className = 'show ' + (isSuccess ? 'success' : 'error');
        setTimeout(() => { toast.className = toast.className.replace('show', ''); }, 4000); // সময় ৪ সেকেন্ড করা হয়েছে
    }

    <?php if (!empty($success_message)): ?>
        showToast('<?php echo $success_message; ?>', true);
    <?php elseif (!empty($error_message)): ?>
        showToast('<?php echo "Upload Failed: " . $error_message; ?>', false);
    <?php endif; ?>

    document.querySelectorAll('.image-uploader').forEach(uploader => {
        const fileInput = uploader.querySelector('input[type="file"]');
        const removeInput = uploader.querySelector('input[type="hidden"]');
        const content = uploader.querySelector('.uploader-content');
        const originalContentHTML = '<div class="uploader-text">Drag & Drop your files or <span class="browse-link">Browse</span></div>';

        const updatePreview = (file) => {
            if (!file) return;
            const reader = new FileReader();
            reader.onload = (e) => {
                content.innerHTML = `
                    <div class="preview-container">
                        <img src="${e.target.result}" alt="Preview" class="image-preview">
                        <button type="button" class="remove-image-btn">&times;</button>
                    </div>`;
                uploader.classList.add('has-preview');
                removeInput.value = "";
            };
            reader.readAsDataURL(file);
        };

        const removePreview = () => {
            fileInput.value = '';
            removeInput.value = "1";
            content.innerHTML = originalContentHTML;
            uploader.classList.remove('has-preview');
        };

        uploader.addEventListener('click', (e) => {
            if (e.target.classList.contains('remove-image-btn')) {
                e.stopPropagation();
                removePreview();
                return;
            }
            fileInput.click();
        });

        fileInput.addEventListener('change', () => updatePreview(fileInput.files[0]));
        uploader.addEventListener('dragover', (e) => { e.preventDefault(); uploader.classList.add('drag-over'); });
        uploader.addEventListener('dragleave', () => uploader.classList.remove('drag-over'));
        uploader.addEventListener('drop', (e) => {
            e.preventDefault();
            uploader.classList.remove('drag-over');
            if (e.dataTransfer.files.length) {
                fileInput.files = e.dataTransfer.files;
                updatePreview(fileInput.files[0]);
            }
        });
    });
});
</script>
</body>
</html>