<?php
require 'auth_check.php';
require 'db_connect.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $original_email = trim($_POST['original_email']);

    // Form data
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $address = trim($_POST['address']) ?: null;
    $city = trim($_POST['city']) ?: null;
    $state = trim($_POST['state']) ?: null;
    $postcode = trim($_POST['postcode']) ?: null;
    $country = trim($_POST['country']) ?: null;

    if (empty($name) || empty($email) || empty($phone) || empty($original_email)) {
        header("Location: customers.php?error=required_fields_missing");
        exit();
    }
    
    try {
        // Update all records matching the original email with new dedicated column data
        $sql = "UPDATE transactions 
                SET customer_name = :name, customer_email = :email, phone = :phone, address = :address, 
                    city = :city, state = :state, postcode = :postcode, country = :country
                WHERE user_id = :user_id AND customer_email = :original_email";
        
        $stmt_update = $pdo->prepare($sql);
        $stmt_update->execute([
            ':name' => $name,
            ':email' => $email,
            ':phone' => $phone,
            ':address' => $address,
            ':city' => $city,
            ':state' => $state,
            ':postcode' => $postcode,
            ':country' => $country,
            ':user_id' => $user_id,
            ':original_email' => $original_email
        ]);

        header("Location: customers.php?success=updated");
        exit();

    } catch (PDOException $e) {
        error_log("Error updating customer: " . $e->getMessage());
        header("Location: customers.php?error=database_error");
        exit();
    }
} else {
    header("Location: customers.php");
    exit();
}
