<?php
// dashboard_project/get_payment_link.php
header('Content-Type: application/json');
require 'auth_check.php';
require 'db_connect.php';

$response = ['success' => false, 'url' => ''];
$link_id = $_POST['id'] ?? null;
$user_id = $_SESSION['user_id'];

if ($link_id) {
    $stmt = $pdo->prepare("SELECT unique_link_id FROM payment_links WHERE id = ? AND user_id = ?");
    $stmt->execute([$link_id, $user_id]);
    $link = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($link) {
        $unique_id = $link['unique_link_id'];
        
        // যদি স্বতন্ত্র আইডি আগে তৈরি না হয়ে থাকে, তবে নতুন করে তৈরি করে সেভ করা
        if (empty($unique_id)) {
            $unique_id = bin2hex(random_bytes(20)); // একটি দীর্ঘ, অনুমান করা কঠিন আইডি
            $update_stmt = $pdo->prepare("UPDATE payment_links SET unique_link_id = ? WHERE id = ?");
            $update_stmt->execute([$unique_id, $link_id]);
        }
        
        // সম্পূর্ণ URL তৈরি করা
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $directory = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
        
        $response['url'] = "{$protocol}://{$host}{$directory}/paymentlink/pay/{$unique_id}";
        $response['success'] = true;
    }
}

echo json_encode($response);
?>