<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];
$sms_id = $_POST['id'] ?? null;

if (!$sms_id) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Record ID is missing.']);
    exit();
}

try {
    // অ্যাপ থেকে পাঠানো ডেটা দিয়ে UPDATE কোয়েরি
    $sql = "UPDATE sms_transactions SET 
                payment_method = :payment_method, 
                type = :type, 
                amount = :amount, 
                sender_number = :sender_number, 
                transaction_id = :transaction_id, 
                reference = :reference, 
                note = :note, 
                status = :status
            WHERE id = :id AND user_id = :user_id";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':payment_method' => $_POST['payment_method'],
        ':type' => $_POST['type'],
        ':amount' => $_POST['amount'] ?: null,
        ':sender_number' => $_POST['sender_number'],
        ':transaction_id' => $_POST['transaction_id'] ?: null,
        ':reference' => $_POST['reference'] ?: null,
        ':note' => $_POST['note'] ?: null,
        ':status' => $_POST['status'],
        ':id' => $sms_id,
        ':user_id' => $user_id
    ]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Record updated successfully.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'No changes were made or record not found.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error during update.', 'error_details' => $e->getMessage()]);
}
?>