<?php
header('Content-Type: application/json');
require '../db_connect.php';

// হেডার থেকে API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

// API Key ব্যবহার করে user_id খুঁজে বের করা
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting_user = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting_user) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting_user['user_id'];

// নতুন একটি API Key তৈরি করা
$new_api_key = bin2hex(random_bytes(32));

// ডেটাবেসে নতুন কী'টি আপডেট করা
try {
    $sql = "UPDATE settings SET api_key = ? WHERE user_id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$new_api_key, $user_id]);

    echo json_encode(['success' => true, 'message' => 'New API Key generated successfully.']);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.']);
}
?>