<?php
header('Content-Type: application/json');
require '../db_connect.php';

// হেডার থেকে API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    // বিস্তারিত এরর মেসেজ পাঠানো হচ্ছে
    echo json_encode(['success' => false, 'message' => 'API Key is missing from request header.']);
    exit();
}

// API Key ব্যবহার করে user_id খুঁজে বের করা
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting_user = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting_user) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key provided. Authentication failed.']);
    exit();
}
$user_id = $setting_user['user_id'];

// settings টেবিল থেকে API Key এবং base_url আনা হচ্ছে
$stmt_settings = $pdo->prepare("SELECT api_key, base_url FROM settings WHERE user_id = ?");
$stmt_settings->execute([$user_id]);
$settings = $stmt_settings->fetch(PDO::FETCH_ASSOC);

if ($settings) {
    // --- ★★★ মূল সমাধান এখানে ★★★ ---
    // base_url যদি ডেটাবেসে NULL বা খালি থাকে, তাহলে একটি ডিফল্ট বা এরর বার্তা পাঠানো হচ্ছে
    $base_url = $settings['base_url'];
    if (empty($base_url)) {
        // যদি বেস ইউআরএল সেট করা না থাকে, তাহলে একটি সুনির্দিষ্ট বার্তা পাঠানো হচ্ছে
        $base_url = "BASE_URL_NOT_SET"; 
    }

    echo json_encode([
        'success' => true,
        'api_key' => $settings['api_key'],
        'base_url' => $base_url
    ]);
} else {
    http_response_code(404);
    echo json_encode(['success' => false, 'message' => 'API settings record not found for this user in the database.']);
}
?>