<?php
header('Content-Type: application/json');
require '../db_connect.php';

// হেডার থেকে API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';

if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

// API Key ব্যবহার করে user_id খুঁজে বের করা
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// অ্যাপ থেকে পাঠানো JSON ডেটা পড়া
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// ডেটা ভ্যালিডেশন
$sender_number = $data['sender_number'] ?? null;
$amount = $data['amount'] ?? null;
$transaction_id = $data['transaction_id'] ?? null;
$full_message = $data['full_message'] ?? null;

if (empty($sender_number) || empty($full_message)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Sender number and full message are required.']);
    exit();
}

// ডেটাবেসে তথ্য সংরক্ষণ করা
try {
    $sql = "INSERT INTO sms_transactions (user_id, sender_number, amount, transaction_id, full_message) 
            VALUES (:user_id, :sender_number, :amount, :transaction_id, :full_message)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':user_id' => $user_id,
        ':sender_number' => $sender_number,
        ':amount' => $amount,
        ':transaction_id' => $transaction_id,
        ':full_message' => $full_message
    ]);

    echo json_encode(['success' => true, 'message' => 'Transaction data received and stored successfully.']);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error during transaction storage.']);
}