<?php
require 'auth_check.php';
require 'db_connect.php';

$user_id = $_SESSION['user_id'];
$success_message = '';
// URL থেকে বর্তমান ট্যাব নির্ধারণ করা হচ্ছে, ডিফল্ট হিসেবে 'general' থাকবে
$active_tab = $_GET['tab'] ?? 'general';

// ফর্ম সাবমিট হলে ডেটা সেভ করার জন্য
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // কোন فرم টি সাবমিট হয়েছে তা বাটনের 'name' দিয়ে পরীক্ষা করা হচ্ছে
    if (isset($_POST['save_general_settings'])) {
        // === জেনারেল সেটিংস সেভ করা ===
        $site_name = trim($_POST['site_name']);
        $timezone = $_POST['timezone'];
        $default_currency = $_POST['default_currency'];
        $currency_symbol = ($default_currency === 'BDT') ? '৳' : '$';
        $default_language = $_POST['default_language'];
        $week_starts_on = $_POST['week_starts_on'];

        $sql_general = "INSERT INTO brand_settings (user_id, site_name, timezone, default_currency, currency_symbol, default_language, week_starts_on) 
                        VALUES (:user_id, :site_name, :timezone, :default_currency, :currency_symbol, :default_language, :week_starts_on)
                        ON DUPLICATE KEY UPDATE 
                        site_name = :site_name, timezone = :timezone, default_currency = :default_currency, 
                        currency_symbol = :currency_symbol, default_language = :default_language, week_starts_on = :week_starts_on";
        
        $stmt = $pdo->prepare($sql_general);
        $stmt->execute([
            ':user_id' => $user_id, ':site_name' => $site_name, ':timezone' => $timezone, 
            ':default_currency' => $default_currency, ':currency_symbol' => $currency_symbol, 
            ':default_language' => $default_language, ':week_starts_on' => $week_starts_on
        ]);
        $success_message = "General settings saved successfully!";
        
    } elseif (isset($_POST['save_color_scheme'])) {
        // === কালার স্কিম সেভ করা ===
        $colors = [
            'user_id' => $user_id,
            'global_text_color' => $_POST['global_text_color'], 'primary_button_color' => $_POST['primary_button_color'],
            'button_text_color' => $_POST['button_text_color'], 'button_hover_color' => $_POST['button_hover_color'],
            'button_hover_text_color' => $_POST['button_hover_text_color'], 'navigation_background' => $_POST['navigation_background'],
            'navigation_text_color' => $_POST['navigation_text_color'], 'active_tab_color' => $_POST['active_tab_color'],
            'active_tab_text_color' => $_POST['active_tab_text_color']
        ];
        
        $sql_colors = "INSERT INTO brand_colors (user_id, global_text_color, primary_button_color, button_text_color, button_hover_color, button_hover_text_color, navigation_background, navigation_text_color, active_tab_color, active_tab_text_color)
                       VALUES (:user_id, :global_text_color, :primary_button_color, :button_text_color, :button_hover_color, :button_hover_text_color, :navigation_background, :navigation_text_color, :active_tab_color, :active_tab_text_color)
                       ON DUPLICATE KEY UPDATE 
                       global_text_color = :global_text_color, primary_button_color = :primary_button_color, button_text_color = :button_text_color, 
                       button_hover_color = :button_hover_color, button_hover_text_color = :button_hover_text_color, navigation_background = :navigation_background, 
                       navigation_text_color = :navigation_text_color, active_tab_color = :active_tab_color, active_tab_text_color = :active_tab_text_color";
        $stmt = $pdo->prepare($sql_colors);
        $stmt->execute($colors);
        $success_message = "Color scheme saved successfully!";

    } elseif (isset($_POST['save_business_details'])) {
        // === বিজনেস ডিটেইলস সেভ করা ===
        $details = [
            'user_id' => $user_id,
            'street_address' => trim($_POST['street_address']),
            'city' => trim($_POST['city']),
            'postal_code' => trim($_POST['postal_code']),
            'country' => $_POST['country']
        ];
        
        $sql_details = "INSERT INTO business_details (user_id, street_address, city, postal_code, country)
                        VALUES (:user_id, :street_address, :city, :postal_code, :country)
                        ON DUPLICATE KEY UPDATE 
                        street_address = :street_address, city = :city, postal_code = :postal_code, country = :country";
        $stmt = $pdo->prepare($sql_details);
        $stmt->execute($details);
        $success_message = "Business details saved successfully!";

    } elseif (isset($_POST['save_support_details'])) {
        // === সাপোর্ট কন্টাক্ট ইনফরমেশন সেভ করা ===
        $support_info = [
            'user_id' => $user_id,
            'support_phone' => trim($_POST['support_phone']),
            'support_email' => trim($_POST['support_email']),
            'support_website' => trim($_POST['support_website'])
        ];
        
        $sql_support = "INSERT INTO support_details (user_id, support_phone, support_email, support_website)
                        VALUES (:user_id, :support_phone, :support_email, :support_website)
                        ON DUPLICATE KEY UPDATE 
                        support_phone = :support_phone, support_email = :support_email, support_website = :support_website";
        $stmt = $pdo->prepare($sql_support);
        $stmt->execute($support_info);
        $success_message = "Support contact information saved successfully!";
    }
}

// === ডেটাবেস থেকে সকল ডেটা আনা ===
$stmt_general = $pdo->prepare("SELECT * FROM brand_settings WHERE user_id = ?"); $stmt_general->execute([$user_id]); $settings = $stmt_general->fetch(PDO::FETCH_ASSOC);
$stmt_colors = $pdo->prepare("SELECT * FROM brand_colors WHERE user_id = ?"); $stmt_colors->execute([$user_id]); $color_settings = $stmt_colors->fetch(PDO::FETCH_ASSOC);
$stmt_details = $pdo->prepare("SELECT * FROM business_details WHERE user_id = ?"); $stmt_details->execute([$user_id]); $business_details = $stmt_details->fetch(PDO::FETCH_ASSOC);
$stmt_support = $pdo->prepare("SELECT * FROM support_details WHERE user_id = ?"); $stmt_support->execute([$user_id]); $support_details = $stmt_support->fetch(PDO::FETCH_ASSOC);

// ডিফল্ট ভ্যালু সেট করা
$defaults = [
    'general' => ['site_name' => 'SecureSoftPayt', 'timezone' => 'Asia/Dhaka', 'default_currency' => 'BDT', 'currency_symbol' => '৳', 'default_language' => 'en', 'week_starts_on' => 'Saturday'],
    'colors' => ['global_text_color' => '#ad0e0e', 'primary_button_color' => '#1d2ecf', 'button_text_color' => '#360c0c', 'button_hover_color' => '#d42929', 'button_hover_text_color' => '#c40b0b', 'navigation_background' => '#c93b3b', 'navigation_text_color' => '#bd1a1a', 'active_tab_color' => '#b52a2a', 'active_tab_text_color' => '#e34848'],
    'business' => ['street_address' => '', 'city' => '', 'postal_code' => '', 'country' => ''],
    'support' => ['support_phone' => '', 'support_email' => '', 'support_website' => '']
];

$current = [
    'general' => $settings ?: $defaults['general'],
    'colors' => $color_settings ?: $defaults['colors'],
    'business' => $business_details ?: $defaults['business'],
    'support' => $support_details ?: $defaults['support']
];

// Helper Functions
function get_timezones() {
    $timezones = [];
    $identifiers = DateTimeZone::listIdentifiers(DateTimeZone::ALL);
    foreach ($identifiers as $identifier) {
        $dateTime = new DateTime('now', new DateTimeZone($identifier));
        $offset = $dateTime->getOffset() / 3600;
        $offset_prefix = $offset < 0 ? '-' : '+';
        $offset_formatted = sprintf('%02d:%02d', abs($offset), abs(($offset*60)%60));
        $timezones[$identifier] = "(UTC{$offset_prefix}{$offset_formatted}) " . str_replace('_', ' ', $identifier);
    }
    return $timezones;
}
$timezone_list = get_timezones();

function get_countries() {
    return ['' => 'Select an option', 'BD' => 'Bangladesh', 'US' => 'United States', 'CA' => 'Canada', 'GB' => 'United Kingdom'];
}
$country_list = get_countries();

include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">Brand Settings > Settings</p>
            <h1 class="page-title">General & Brand Settings</h1>
        </div>
    </div>

    <div class="content-card">
        <div class="settings-tabs">
            <a href="?tab=general" class="tab-item <?php echo ($active_tab === 'general') ? 'active' : ''; ?>"><i class="fas fa-sliders-h"></i> General <span class="tab-badge">Core</span></a>
            <a href="?tab=branding" class="tab-item <?php echo ($active_tab === 'branding') ? 'active' : ''; ?>"><i class="fas fa-paint-brush"></i> Branding <span class="tab-badge visual">Visual</span></a>
            <a href="?tab=business" class="tab-item <?php echo ($active_tab === 'business') ? 'active' : ''; ?>"><i class="fas fa-building"></i> Business Details</a>
            <a href="?tab=contact" class="tab-item <?php echo ($active_tab === 'contact') ? 'active' : ''; ?>"><i class="fas fa-link"></i> Contact & Social</a>
        </div>
        
        <div class="tab-content">
            <?php if ($active_tab === 'general'): ?>
            <!-- === জেনারেল সেটিংস ট্যাব === -->
            <form action="?tab=general" method="POST">
                <div class="settings-section">
                    <h3>Basic Information</h3><p>Configure the core settings for your application</p>
                    <div class="form-grid">
                        <div class="form-group"><label for="site_name">Site Name<span class="required-star">*</span></label><input type="text" id="site_name" name="site_name" value="<?php echo htmlspecialchars($current['general']['site_name']); ?>" required><small>This will appear in the browser title and various places throughout the application</small></div>
                        <div class="form-group"><label for="timezone">Default Timezone<span class="required-star">*</span></label><div class="select-wrapper"><select id="timezone" name="timezone" required><?php foreach ($timezone_list as $key => $value): ?><option value="<?php echo $key; ?>" <?php echo ($key === $current['general']['timezone']) ? 'selected' : ''; ?>><?php echo $value; ?></option><?php endforeach; ?></select></div><small>All dates and times will be displayed according to this timezone</small></div>
                    </div>
                </div>
                <div class="settings-section">
                    <h3>Currency & Financial</h3><p>Configure currency settings</p>
                    <div class="form-grid">
                        <div class="form-group"><label for="default_currency">Default Currency<span class="required-star">*</span></label><div class="select-wrapper"><select id="default_currency" name="default_currency" required><option value="BDT" <?php echo ($current['general']['default_currency'] === 'BDT') ? 'selected' : ''; ?>>BDT</option><option value="USD" <?php echo ($current['general']['default_currency'] === 'USD') ? 'selected' : ''; ?>>USD</option></select></div><small>Currency used for all financial transactions</small></div>
                        <div class="form-group"><label for="currency_symbol">Currency Symbol</label><input type="text" id="currency_symbol" name="currency_symbol" value="<?php echo htmlspecialchars($current['general']['currency_symbol']); ?>" readonly><small>Automatically set based on selected currency</small></div>
                    </div>
                </div>
                <div class="settings-section">
                    <h3>Localization</h3><p>Configure language and date format preferences</p>
                    <div class="form-grid">
                        <div class="form-group"><label for="default_language">Default Language<span class="required-star">*</span></label><div class="select-wrapper"><select id="default_language" name="default_language" required><option value="" disabled>Select an option</option><option value="en" <?php echo ($current['general']['default_language'] === 'en') ? 'selected' : ''; ?>>English</option><option value="bn" <?php echo ($current['general']['default_language'] === 'bn') ? 'selected' : ''; ?>>Bengali</option></select></div><small>Checkout interface language</small></div>
                        <div class="form-group"><label for="week_starts_on">Week Starts On<span class="required-star">*</span></label><div class="select-wrapper"><select id="week_starts_on" name="week_starts_on" required><?php $days = ['Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday']; foreach ($days as $day) { echo "<option value='{$day}' " . (($current['general']['week_starts_on'] === $day) ? 'selected' : '') . ">{$day}</option>"; } ?></select></div><small>Determines first day of week in reports</small></div>
                    </div>
                </div>
                <div class="settings-actions"><button type="submit" name="save_general_settings" class="btn btn-primary">Save Changes</button></div>
            </form>
            
            <?php elseif ($active_tab === 'branding'): ?>
            <!-- === ব্র্যান্ডিং (কালার স্কিম) ট্যাব === -->
            <form action="?tab=branding" method="POST">
                <div class="settings-section">
                    <h3>Color Scheme</h3><p>Customize your brand colors</p>
                    <div class="form-grid-3-col">
                        <?php
                        function render_color_input($name, $label, $value, $description) {
                            echo '<div class="form-group"><label for="'.$name.'">'.$label.'</label><div class="form-group-color"><input type="text" id="'.$name.'" name="'.$name.'" value="'.htmlspecialchars($value).'"><input type="color" data-target="'.$name.'" value="'.htmlspecialchars($value).'"></div><small>'.$description.'</small></div>';
                        }
                        render_color_input('global_text_color', 'Global Text Color', $current['colors']['global_text_color'], 'Default text color throughout the app');
                        render_color_input('primary_button_color', 'Primary Button Color', $current['colors']['primary_button_color'], 'Background color for primary buttons');
                        render_color_input('button_text_color', 'Button Text Color', $current['colors']['button_text_color'], 'Text color for primary buttons');
                        render_color_input('button_hover_color', 'Button Hover Color', $current['colors']['button_hover_color'], 'Background color when hovering');
                        render_color_input('button_hover_text_color', 'Button Hover Text Color', $current['colors']['button_hover_text_color'], 'Text color when hovering');
                        render_color_input('navigation_background', 'Navigation Background', $current['colors']['navigation_background'], 'Background for navigation elements');
                        render_color_input('navigation_text_color', 'Navigation Text Color', $current['colors']['navigation_text_color'], 'Text color for navigation elements');
                        render_color_input('active_tab_color', 'Active Tab Color', $current['colors']['active_tab_color'], 'Background for selected tabs');
                        render_color_input('active_tab_text_color', 'Active Tab Text Color', $current['colors']['active_tab_text_color'], 'Text color for selected tabs');
                        ?>
                    </div>
                </div>
                <div class="settings-actions"><button type="submit" name="save_color_scheme" class="btn btn-primary">Save Changes</button></div>
            </form>
            
            <?php elseif ($active_tab === 'business'): ?>
            <!-- === বিজনেস ডিটেইলস ট্যাব === -->
            <form action="?tab=business" method="POST">
                <div class="settings-section">
                    <h3>Company Information</h3><p>Enter your business details for invoices and documentation</p>
                    <div class="form-grid">
                        <div class="form-group"><label for="street_address">Street Address</label><input type="text" id="street_address" name="street_address" value="<?php echo htmlspecialchars($current['business']['street_address']); ?>"><small>Street address including building/suite number</small></div>
                        <div class="form-group"><label for="city">City/Town</label><input type="text" id="city" name="city" value="<?php echo htmlspecialchars($current['business']['city']); ?>"><small>City or town name</small></div>
                        <div class="form-group"><label for="postal_code">Postal/ZIP Code</label><input type="text" id="postal_code" name="postal_code" value="<?php echo htmlspecialchars($current['business']['postal_code']); ?>"><small>Postal or ZIP code</small></div>
                        <div class="form-group"><label for="country">Country</label><div class="select-wrapper"><select id="country" name="country"><?php foreach($country_list as $code => $name): ?><option value="<?php echo $code; ?>" <?php echo ($current['business']['country'] === $code) ? 'selected' : ''; ?>><?php echo $name; ?></option><?php endforeach; ?></select></div><small>Country where your business is registered</small></div>
                    </div>
                </div>
                <div class="settings-actions"><button type="submit" name="save_business_details" class="btn btn-primary">Save Changes</button></div>
            </form>

            <?php elseif ($active_tab === 'contact'): ?>
            <!-- === কন্টাক্ট ও সোশ্যাল ট্যাব === -->
            <form action="?tab=contact" method="POST">
                <div class="settings-section">
                    <h3>Support Contact Information</h3><p>Configure support channels for your customers</p>
                    <div class="form-grid-3-col">
                        <div class="form-group"><label for="support_phone">Support Phone Number</label><input type="text" id="support_phone" name="support_phone" value="<?php echo htmlspecialchars($current['support']['support_phone']); ?>"><small>Customer service phone number (with country code)</small></div>
                        <div class="form-group"><label for="support_email">Support Email Address</label><input type="email" id="support_email" name="support_email" value="<?php echo htmlspecialchars($current['support']['support_email']); ?>"><small>Primary contact email for support inquiries</small></div>
                        <div class="form-group"><label for="support_website">Support Website</label><div class="input-with-prefix"><span>https://</span><input type="text" id="support_website" name="support_website" placeholder="help.yourcompany.com" value="<?php echo htmlspecialchars($current['support']['support_website']); ?>"></div><small>Link to your support portal or help center</small></div>
                    </div>
                </div>
                <div class="settings-actions"><button type="submit" name="save_support_details" class="btn btn-primary">Save Changes</button></div>
            </form>
            <?php endif; ?>
        </div>
    </div>
</div>

</div> <!-- .main-content -->
<div id="toast-notification"></div>
<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    <?php if (!empty($success_message)): ?>
        showToast('<?php echo $success_message; ?>', true);
    <?php endif; ?>
    
    // Currency & Symbol logic
    const currencySelect = document.getElementById('default_currency');
    if(currencySelect) { currencySelect.addEventListener('change', function() { document.getElementById('currency_symbol').value = (this.value === 'BDT') ? '৳' : '$'; }); }

    // Color picker logic
    document.querySelectorAll('.form-group-color input[type="color"]').forEach(picker => { picker.addEventListener('input', function() { document.getElementById(this.dataset.target).value = this.value; }); });
    document.querySelectorAll('.form-group-color input[type="text"]').forEach(input => { input.addEventListener('input', function() { this.nextElementSibling.value = this.value; }); });
});
function showToast(message, isSuccess) {
    const toast = document.getElementById('toast-notification');
    if (!toast) return;
    toast.textContent = message;
    toast.className = 'show ' + (isSuccess ? 'success' : 'error');
    setTimeout(() => { toast.className = toast.className.replace('show', ''); }, 3000);
}
</script>
</body>
</html>