<?php
require '../db_connect.php';

// .htaccess থেকে আসা লিঙ্ক আইডি
$unique_link_id = $_GET['link_id'] ?? null;
if (!$unique_link_id) {
    die("Payment Link ID is missing.");
}

// লিঙ্কের তথ্য ডেটাবেস থেকে আনা
$stmt_link = $pdo->prepare("SELECT * FROM payment_links WHERE unique_link_id = ?");
$stmt_link->execute([$unique_link_id]);
$link_details = $stmt_link->fetch(PDO::FETCH_ASSOC);

// লিঙ্কটি বৈধ কিনা তা পরীক্ষা করা
if (!$link_details || $link_details['status'] == 0) {
    http_response_code(404);
    die("This payment link is invalid or inactive.");
}
if (!$link_details['is_default'] && $link_details['quantity'] <= 0) {
    http_response_code(404);
    die("This payment link is no longer available.");
}

$user_id = $link_details['user_id'];

// ফর্ম সাবমিট হলে এই অংশটি কাজ করবে
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // ফর্ম থেকে ডেটা গ্রহণ করা
    $customer_name = trim($_POST['full_name']);
    $customer_email = trim($_POST['email']);
    $customer_mobile = trim($_POST['mobile_number']);
    
    // লিঙ্কের ধরন অনুযায়ী অ্যামাউন্ট এবং রেফারেন্স সেট করা
    if ($link_details['is_default']) {
        $amount = (float)$_POST['amount'];
        $reference = trim($_POST['reference']) ?: null;
    } else {
        $amount = $link_details['amount']; // পরিমাণ নির্দিষ্ট
        $reference = null;
    }
    
    if (empty($customer_name) || empty($customer_email) || empty($customer_mobile) || $amount <= 0) {
        die("Please fill all required fields correctly.");
    }

    try {
        // মূল transactions টেবিলে পেমেন্ট সেশন তৈরি করা
        $transaction_unique_id = sha1(uniqid(rand(), true) . microtime());
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $directory = rtrim(dirname(dirname($_SERVER['PHP_SELF'])), '/\\');
        $base_project_url = "{$protocol}://{$host}{$directory}";
        $cancel_url = "{$base_project_url}/checkout?trx_id={$transaction_unique_id}&status=cancelled";

        $meta_data = [
            'source' => $link_details['is_default'] ? 'default_payment_link' : 'payment_link',
            'payment_link_id' => $link_details['id'],
            'customer_mobile' => $customer_mobile,
            'reference' => $reference // ডিফল্ট লিঙ্কের রেফারেন্স
        ];

        $sql_trans = "INSERT INTO transactions (user_id, unique_id, amount, customer_name, customer_email, success_url, cancel_url, meta_data) 
                      VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt_trans = $pdo->prepare($sql_trans);
        $stmt_trans->execute([$user_id, $transaction_unique_id, $amount, $customer_name, $customer_email, $base_project_url, $cancel_url, json_encode($meta_data)]);
        
        header("Location: {$base_project_url}/checkout?trx_id=" . $transaction_unique_id);
        exit();

    } catch (PDOException $e) {
        die("Could not initiate payment session: " . $e->getMessage());
    }
}

// === HTML View পার্ট ===
$base_project_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]" . rtrim(dirname(dirname($_SERVER['PHP_SELF'])), '/\\');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Complete Your Payment</title>
    <link rel="stylesheet" href="<?php echo $base_project_url; ?>/css/style.css?v=<?php echo filemtime('../css/style.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<?php if ($link_details['is_default']): ?>
<!-- ডিফল্ট লিঙ্কের জন্য ভিউ -->
<body class="default-link-body">
    <div class="default-link-container">
        <div class="left-panel">
            <img src="<?php echo $base_project_url; ?>/images/logo.png" alt="Company Logo" class="company-logo">
            <img src="<?php echo $base_project_url; ?>/images/customer-attraction.png" alt="Illustration" class="illustration-img">
        </div>
        <div class="right-panel">
            <form action="" method="POST">
                <div class="form-input-group"><i class="fas fa-user"></i><input type="text" name="full_name" placeholder="Full Name" required></div>
                <div class="form-input-group"><i class="fas fa-envelope"></i><input type="email" name="email" placeholder="Email" required></div>
                <div class="form-input-group"><i class="fas fa-phone"></i><input type="text" name="mobile_number" placeholder="Mobile Number" required></div>
                <div class="form-input-group"><i class="fas fa-dollar-sign"></i><input type="number" step="0.01" name="amount" placeholder="Amount" required></div>
                <div class="form-input-group"><i class="fas fa-paper-plane"></i><input type="text" name="reference" placeholder="Reference (optional)"></div>
                <button type="submit" class="btn btn-primary submit-btn">Submit</button>
            </form>
        </div>
    </div>
</body>
<?php else: ?>
<!-- সাধারণ লিঙ্কের জন্য ভিউ -->
<body class="cancellation-body">
    <div class="link-form-container">
        <div class="link-form-header">
             <div class="product-image-wrapper"><img src="<?php echo $base_project_url; ?>/images/product-placeholder.png" alt="Product Image"></div>
            <h2><?php echo htmlspecialchars($link_details['product_name']); ?></h2>
            <p><?php echo htmlspecialchars($link_details['product_description']); ?></p>
        </div>
        <form action="" method="POST" class="link-form-body">
            <div class="form-row">
                <div class="form-group half-width"><label for="full_name">Full Name <span class="required-star">*</span></label><input type="text" id="full_name" name="full_name" required></div>
                <div class="form-group half-width"><label for="email">Email <span class="required-star">*</span></label><input type="email" id="email" name="email" required></div>
            </div>
            <div class="form-group"><label for="mobile">Mobile Number <span class="required-star">*</span></label><input type="text" id="mobile" name="mobile_number" required></div>
            <button type="submit" class="btn btn-primary" style="width: 100%; margin-top: 15px; padding: 15px; font-size: 18px;">Pay <?php echo htmlspecialchars($link_details['amount']); ?> BDT</button>
        </form>
    </div>
</body>
<?php endif; ?>
</html>