<?php
header('Content-Type: application/json');
require '../db_connect.php';

use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelHigh;
use Endroid\QrCode\RoundBlockSizeMode\RoundBlockSizeModeMargin;
use Endroid\QrCode\Writer\PngWriter;

try {
    // API Key হেডার থেকে অথেন্টিকেশন
    $api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
    if (empty($api_key)) {
        http_response_code(401);
        throw new Exception("API Key is missing.");
    }

    $stmt_user_lookup = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
    $stmt_user_lookup->execute([$api_key]);
    $setting = $stmt_user_lookup->fetch(PDO::FETCH_ASSOC);

    if (!$setting) {
        http_response_code(403);
        throw new Exception("Invalid API Key.");
    }
    $user_id = $setting['user_id'];

    // নতুন, একবার-ব্যবহারযোগ্য টোকেন তৈরি এবং ডাটাবেসে সেভ
    $token = bin2hex(random_bytes(32));
    $stmt_token_update = $pdo->prepare("UPDATE users SET app_auth_token = ? WHERE id = ?");
    $stmt_token_update->execute([$token, $user_id]);

    // ব্যবহারকারীর ডেটা (ইমেইল, বেস ইউআরএল) আনা
    $stmt_user_data = $pdo->prepare(
        "SELECT u.email, s.base_url 
        FROM users u 
        LEFT JOIN settings s ON u.id = s.user_id 
        WHERE u.id = ?"
    );
    $stmt_user_data->execute([$user_id]);
    $user_data = $stmt_user_data->fetch(PDO::FETCH_ASSOC);

    if (!$user_data || empty($user_data['base_url']) || empty($user_data['email'])) {
        throw new Exception("User email or API Base URL not found. Please visit API Settings page first.");
    }

    // অ্যাপে JSON ডেটা পাঠানো
    echo json_encode([
        'success' => true,
        'email'   => $user_data['email'],
        'baseUrl' => $user_data['base_url'],
        'token'   => $token
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>