<?php
header('Content-Type: application/json');
require '../db_connect.php';

$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) { http_response_code(401); die(json_encode(['success' => false, 'message' => 'API Key is missing.'])); }

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) { http_response_code(403); die(json_encode(['success' => false, 'message' => 'Invalid API Key.'])); }

$user_id = $setting['user_id'];

// ★★★ সমাধান: $_POST থেকে ডেটা গ্রহণ করা হচ্ছে ★★★
$trx_id = $_POST['trx_id'] ?? null;

if (!$trx_id) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Transaction ID is missing.']);
    exit();
}

try {
    $pdo->beginTransaction();

    $stmt_fund = $pdo->prepare("SELECT * FROM user_funds WHERE transaction_unique_id = ? AND user_id = ? AND status = 'pending' FOR UPDATE");
    $stmt_fund->execute([$trx_id, $user_id]);
    $fund_details = $stmt_fund->fetch(PDO::FETCH_ASSOC);

    if (!$fund_details) {
        throw new Exception('Funding record not found or already processed.');
    }

    $stmt_trans = $pdo->prepare("SELECT status FROM transactions WHERE unique_id = ? AND user_id = ?");
    $stmt_trans->execute([$trx_id, $user_id]);
    $transaction = $stmt_trans->fetch(PDO::FETCH_ASSOC);

    if ($transaction && $transaction['status'] === 'completed') {
        $stmt_update_fund = $pdo->prepare("UPDATE user_funds SET status = 'completed' WHERE id = ?");
        $stmt_update_fund->execute([$fund_details['id']]);

        $stmt_update_balance = $pdo->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
        $stmt_update_balance->execute([$fund_details['amount_usd'], $user_id]);
        
        $pdo->commit();
        echo json_encode(['success' => true, 'message' => 'Funds added successfully!']);
    } else {
        throw new Exception('Payment verification failed or payment is not completed.');
    }

} catch (Exception $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>