<?php
// এই অংশটি কোনো HTML আউটপুটের আগে ফাইলের самом শীর্ষে থাকবে।
if (isset($_SESSION['db_success']) && !isset($_SESSION['admin_credentials'])) {
    // কেন্দ্রীয় সার্ভারে কল করে অ্যাডমিন তথ্য তৈরি করা হচ্ছে
    $central_api_url = 'https://settings.top/dashboard_project/api/create_instance_admin.php'; // ★★★ আপনার মূল সার্ভারের API URL
    $license_key = $_SESSION['license_key'];
    // ★★★ সমাধান: সেশন থেকে লাইসেন্স স্ট্যাটাস আনা হচ্ছে ★★★
    $license_status = $_SESSION['license_status'] ?? 'active';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $central_api_url);
    curl_setopt($ch, CURLOPT_POST, 1);
    // ★★★ সমাধান: license_status প্যারামিটারটি API কলে যুক্ত করা হয়েছে ★★★
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'license_key' => $license_key,
        'license_status' => $license_status 
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $result = json_decode($response, true);

    if ($result && isset($result['success']) && $result['success']) {
        $_SESSION['admin_credentials'] = $result['credentials'];
    } else {
        // সার্ভার থেকে আসা সুনির্দিষ্ট এরর বার্তাটি এখানে সেভ করা হচ্ছে
        $_SESSION['admin_credentials'] = ['error' => $result['message'] ?? 'Could not create admin user from the central server.'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Installation Finished - Setup Wizard</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Installation Complete!</h1>
        <p class="success">Your application has been installed successfully.</p>

        <div class="content">
            <h3>Your Admin Login Details</h3>
            <?php if (isset($_SESSION['admin_credentials']) && !isset($_SESSION['admin_credentials']['error'])): ?>
                <div class="form-group">
                    <label>Username</label>
                    <input type="text" value="<?php echo htmlspecialchars($_SESSION['admin_credentials']['username']); ?>" readonly>
                </div>
                 <div class="form-group">
                    <label>Password</label>
                    <input type="text" value="<?php echo htmlspecialchars($_SESSION['admin_credentials']['password']); ?>" readonly>
                </div>
                <p>Please save these details in a secure location. You will use these to log in.</p>
            <?php else: ?>
                <!-- এখানে কেন্দ্রীয় সার্ভার থেকে আসা এরর বার্তাটি দেখানো হবে -->
                <p class="error"><?php echo htmlspecialchars($_SESSION['admin_credentials']['error'] ?? 'An unknown error occurred while creating your admin account.'); ?></p>
            <?php endif; ?>
        </div>

        <div class="warning">
            <h3><strong>IMPORTANT:</strong> Delete the Install Directory</h3>
            <p>For security reasons, you must now delete the <strong>/install/</strong> directory from your server before you can log in.</p>
        </div>
        <br>
        <a href="../login.php" class="button">Go to Login Page</a>
    </div>
</body>
</html>