document.addEventListener('DOMContentLoaded', () => {
    // --- গ্লোবাল ভেরিয়েবল ---
    const sidebar = document.getElementById('sidebar');
    const mainContent = document.getElementById('main-content');
    const sidebarToggle = document.getElementById('sidebar-toggle');
    const themeToggle = document.getElementById('theme-toggle');
    const sidebarMenu = document.getElementById('sidebarMenu'); // মেনু <UL> এলিমেন্ট

    // ====================================================================
    // ★★★ সাইডবারের অবস্থা (State) এবং স্ক্রল পজিশন ম্যানেজমেন্ট ★★★
    // ====================================================================

    // পেজ লোড হওয়ার সময় localStorage থেকে সাইডবারের অবস্থা এবং স্ক্রল পজিশন লোড করা
    if (localStorage.getItem('sidebarCollapsed') === 'true') {
        if (sidebar) sidebar.classList.add('collapsed');
        if (mainContent) mainContent.classList.add('full-width');
    }

    const savedScrollTop = localStorage.getItem('sidebarScrollTop');
    if (savedScrollTop !== null && sidebarMenu) {
        // একটি ছোট ডিলে দেওয়া হচ্ছে যাতে DOM পুরোপুরি রেন্ডার হওয়ার পর স্ক্রল সেট হয়
        setTimeout(() => {
            sidebarMenu.scrollTop = parseInt(savedScrollTop, 10);
        }, 100);
    }

    // পেজ বন্ধ বা রিফ্রেশ করার আগে সাইডবারের স্ক্রল পজিশন localStorage-এ সেভ করা
    window.addEventListener('beforeunload', () => {
        if (sidebarMenu) {
            localStorage.setItem('sidebarScrollTop', sidebarMenu.scrollTop);
        }
    });

    // --- সাইডবার টগল ফাংশন ---
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', () => {
            if (sidebar) sidebar.classList.toggle('collapsed');
            if (mainContent) mainContent.classList.toggle('full-width');
            
            // টগল করার পর সাইডবারের নতুন অবস্থা localStorage-এ সেভ করা
            if (sidebar && sidebar.classList.contains('collapsed')) {
                localStorage.setItem('sidebarCollapsed', 'true');
            } else {
                localStorage.setItem('sidebarCollapsed', 'false');
            }
        });
    }

    // --- থিম টগল (ডার্ক/লাইট মোড) ফাংশন ---
    if (themeToggle) {
        themeToggle.addEventListener('click', () => {
            document.body.classList.toggle('dark-mode');
            if (document.body.classList.contains('dark-mode')) {
                themeToggle.textContent = 'light_mode';
                localStorage.setItem('theme', 'dark');
            } else {
                themeToggle.textContent = 'brightness_4';
                localStorage.setItem('theme', 'light');
            }
        });
    }
    
    // পেজ লোড হওয়ার সময় সেভ করা থিম লোড করা
    if (localStorage.getItem('theme') === 'dark') {
        document.body.classList.add('dark-mode');
        if(themeToggle) themeToggle.textContent = 'light_mode';
    }

    // --- সক্রিয় মেনু লিংক হাইলাইট করা ---
    if (sidebarMenu) {
        const currentPath = window.location.pathname.split("/").pop();
        if (currentPath) {
            const menuLinks = sidebarMenu.querySelectorAll('a');
            let foundActive = false;
            menuLinks.forEach(link => {
                if (link.getAttribute('href') === currentPath) {
                    link.parentElement.classList.add('active');
                    foundActive = true;
                } else {
                    link.parentElement.classList.remove('active');
                }
            });
            // যদি কোনো পেজ না মেলে (যেমন index.php), তাহলে ড্যাশবোর্ডকে সক্রিয় রাখা
            if (!foundActive) {
                const dashboardLink = sidebarMenu.querySelector('a[href="index.php"]');
                if (dashboardLink) {
                    dashboardLink.parentElement.classList.add('active');
                }
            }
        }
    }

    // ====================================================================
    // ★★★ পুরোনো সমস্ত ফাংশনালিটি (যেমন মডাল, টোস্ট ইত্যাদি) ★★★
    // ====================================================================

    // --- টোস্ট নোটিফিকেশন দেখানোর জন্য গ্লোবাল ফাংশন ---
    function showToast(message, isSuccess) {
        const toast = document.getElementById('toast-notification');
        if (!toast) return;
        toast.textContent = message;
        toast.className = 'show ' + (isSuccess ? 'success' : 'error');
        setTimeout(() => {
            toast.className = toast.className.replace('show', '');
        }, 3000);
    }

    // --- Gateway Modal (payment.php) ---
    const gatewayModal = document.getElementById('gatewayModal');
    const openGatewayModalBtn = document.getElementById('openModalBtn');
    if (gatewayModal && openGatewayModalBtn) {
        const closeButton = gatewayModal.querySelector('.close-button');
        const cancelButton = gatewayModal.querySelector('.cancel-btn');
        openGatewayModalBtn.onclick = () => { gatewayModal.style.display = 'block'; };
        if(closeButton) closeButton.onclick = () => { gatewayModal.style.display = 'none'; };
        if(cancelButton) cancelButton.onclick = () => { gatewayModal.style.display = 'none'; };
        window.addEventListener('click', (event) => {
            if (event.target == gatewayModal) {
                gatewayModal.style.display = 'none';
            }
        });
    }

    // --- Connect App সাইড প্যানেল (devices.php & sms_data.php) ---
    const connectAppPanel = document.getElementById('connectAppPanel');
    if (connectAppPanel) {
        const openButtons = document.querySelectorAll('#connectAppBtn');
        const closeButton = connectAppPanel.querySelector('#closePanelBtn');

        openButtons.forEach(btn => {
            btn.addEventListener('click', (e) => {
                e.preventDefault();
                connectAppPanel.classList.add('open');
            });
        });

        if (closeButton) {
            closeButton.addEventListener('click', () => {
                connectAppPanel.classList.remove('open');
            });
        }
        
        connectAppPanel.addEventListener('click', (e) => {
            if (e.target === connectAppPanel) {
                connectAppPanel.classList.remove('open');
            }
        });
    }

    // --- Update Notification Popup (header.php) ---
    const updateModalOverlay = document.getElementById('update-notification-overlay');
    if (updateModalOverlay) {
        const remindLaterBtn = document.getElementById('remind-later-btn');
        const closePopupBtn = document.getElementById('close-update-popup-btn');
        const licenseKey = document.body.dataset.licenseKey || '';
        const currentVersion = document.body.dataset.appVersion || '0.0.0';

        function showUpdatePopup() { if (updateModalOverlay) updateModalOverlay.style.display = 'flex'; }
        function hideUpdatePopup() {
            if (updateModalOverlay) {
                updateModalOverlay.style.display = 'none';
                sessionStorage.setItem('updateNoticeDismissed', 'true');
            }
        }

        if(remindLaterBtn) remindLaterBtn.addEventListener('click', hideUpdatePopup);
        if(closePopupBtn) closePopupBtn.addEventListener('click', hideUpdatePopup);

        function checkForUpdate() {
            // This function needs access to PHP defined variables, which is better handled inline in the PHP file.
            // Keeping the logic here as a placeholder for completeness.
            // The original inline script in header.php is more reliable for this.
        }
        
        const currentPage = window.location.pathname.split("/").pop();
        if (currentPage !== 'update_manager.php' && sessionStorage.getItem('updateNoticeDismissed') !== 'true') {
            // checkForUpdate(); // This should be called from the inline script in header.php
        }
    }
});