<?php
// update_manager.php (v3.1)

require 'auth_check.php';
require 'db_connect.php'; 

include 'templates/header.php';
include 'templates/sidebar.php';

// --- Cron Job কমান্ড তৈরির জন্য PHP কোড ---
$php_path = '/usr/local/bin/php';
if (defined('PHP_BINARY') && is_executable(PHP_BINARY) && strpos(PHP_BINARY, 'lsphp') === false) {
    $php_path = PHP_BINARY;
}
$script_path = __DIR__ . '/run_updater.php';
$log_path = __DIR__ . '/cron_log.txt';
$cron_command_only = "{$php_path} -q {$script_path} >> {$log_path} 2>&1";
?>

<!-- পেজের মূল HTML কন্টেন্ট শুরু -->
<div class="page-container">
    <div class="page-header">
        <h1 class="page-title">Application Updater</h1>
    </div>

    <div class="content-card" style="margin-bottom: 20px;">
        <h3>Update Status</h3>
        <p>Your current version: <strong><?php echo defined('APP_VERSION') ? htmlspecialchars(APP_VERSION) : 'N/A'; ?></strong></p>
        
        <div id="update-status-area">
            <!-- ডিফল্ট বার্তা -->
            <p id="status-text">Checking for new updates...</p>
            
            <!-- শুধুমাত্র ম্যানুয়াল আপডেটের জন্য এই ডিজাইনটি দেখানো হবে -->
            <div id="manual-update-box" style="display: none; border: 2px solid #0d6efd; padding: 20px; border-radius: 12px; margin-top: 15px; background-color: #f7f9ff;">
                <h4 style="margin-top:0; font-size: 1.3rem;">A new version is ready to install!</h4>
                <p>New Version: <strong id="new-version-number" style="font-size: 1.1rem;"></strong></p>
                <button id="install-now-btn" class="btn btn-primary" style="padding: 12px 25px; font-size: 1rem;">
                    <i class="fas fa-download"></i> Install Now
                </button>
            </div>
            
            <!-- ইনস্টলেশন პროგრెస్ দেখানোর জন্য -->
            <div id="install-progress" style="display: none; margin-top: 15px;">
                <p id="progress-text">Installing update... Please do not close this window.</p>
                <div class="progress-bar-container" style="display: block; border-radius: 50px; background-color: #e9ecef;">
                    <div id="progress-bar" class="progress-bar" style="width: 0%; border-radius: 50px;">0%</div>
                </div>
            </div>
        </div>

        <!-- সফল বা ব্যর্থ বার্তা দেখানোর স্থান -->
        <div id="final-message" style="margin-top: 15px; padding: 15px; border-radius: 8px; display: none; font-weight: 500;"></div>
    </div>

    <!-- Cron Job সেকশন -->
    <div class="content-card">
        <h3>Automatic Updates Setup (Cron Job)</h3>
        <p>To enable automatic updates, set up a Cron Job on your server's control panel (e.g., cPanel).</p>
        <div class="form-group" style="margin-top: 20px;">
            <label>Timing (Common Settings)</label>
            <pre><code>Once Per Five Minutes (*/5 * * * *)</code></pre>
        </div>
        <div class="form-group">
            <label>Command</label>
            <pre><code><?php echo htmlspecialchars($cron_command_only); ?></code></pre>
        </div>
    </div>
</div>

<style>
    #final-message.success { background-color: #d1e7dd; color: #0f5132; }
    #final-message.error { background-color: #f8d7da; color: #842029; }
    .progress-bar-container { width: 100%; background-color: #e9ecef; border-radius: 8px; }
    .progress-bar { width: 0%; height: 25px; background-color: #0d6efd; text-align: center; line-height: 25px; color: white; border-radius: 8px; transition: width 0.4s ease; }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusText = document.getElementById('status-text');
    const manualUpdateBox = document.getElementById('manual-update-box');
    const newVersionDisplay = document.getElementById('new-version-number');
    const installBtn = document.getElementById('install-now-btn');
    const installProgress = document.getElementById('install-progress');
    const finalMessage = document.getElementById('final-message');
    const progressBar = document.getElementById('progress-bar');
    
    const licenseKey = '<?php echo defined('LICENSE_KEY') ? LICENSE_KEY : ''; ?>';
    const currentVersion = '<?php echo defined('APP_VERSION') ? APP_VERSION : '0.0.0'; ?>';

    function checkForUpdates() {
        fetch('manual_update_handler.php?action=check', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({'license_key': licenseKey, 'current_version': currentVersion})
        })
        .then(response => response.json())
        .then(data => {
            // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // ★★★                  মূল সমাধান                ★★★
            // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

            // ধাপ ১: শুধুমাত্র ম্যানুয়াল আপডেট হলেই নোটিফিকেশন দেখানো হবে
            if (data.update_available && data.update_type === 'manual') {
                // আপনার অনুরোধ অনুযায়ী, এখানে আর "manual update" শব্দটি নেই
                statusText.textContent = 'A new update is available for installation.';
                newVersionDisplay.textContent = data.version;
                manualUpdateBox.style.display = 'block';
            } 
            // ধাপ ২: যদি কোনো আপডেট না থাকে অথবা অটোমেটিক আপডেট থাকে, তাহলে 'up-to-date' বার্তা দেখানো হবে
            else if (data.update_available === false || (data.update_available && data.update_type === 'automatic')) {
                statusText.textContent = 'Your application is up-to-date.';
                statusText.style.color = '#198754';
                statusText.style.fontWeight = '500';
            } 
            // ধাপ ৩: অন্য কোনো সমস্যা হলে এরর দেখানো হবে
            else {
                throw new Error(data.message || 'Invalid response from server.');
            }
        })
        .catch(error => {
            statusText.textContent = 'Could not check for updates: ' + error.message;
            statusText.style.color = '#dc3545';
        });
    }

    installBtn.addEventListener('click', function() {
        this.disabled = true;
        this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Installing...';
        manualUpdateBox.style.display = 'none';
        statusText.style.display = 'none';
        installProgress.style.display = 'block';

        // সিমুলেটেড პროგრెస్ বার
        let width = 10;
        const interval = setInterval(() => {
            if (width < 90) { width += Math.floor(Math.random() * 10); progressBar.style.width = width + '%'; progressBar.textContent = width + '%'; }
        }, 300);

        fetch('manual_update_handler.php?action=install', { method: 'POST' })
        .then(response => response.json())
        .then(data => {
            clearInterval(interval);
            progressBar.style.width = '100%';
            progressBar.textContent = '100%';
            installProgress.style.display = 'none';
            finalMessage.style.display = 'block';

            if (data.success) {
                finalMessage.className = 'success';
                finalMessage.textContent = data.message + ' Page will reload shortly.';
                setTimeout(() => { window.location.reload(); }, 3000);
            } else {
                finalMessage.className = 'error';
                finalMessage.textContent = 'Update Failed: ' + (data.message || 'Unknown error.');
                this.disabled = false;
                this.innerHTML = '<i class="fas fa-sync-alt"></i> Try Again';
            }
        })
        .catch(error => {
            clearInterval(interval);
            installProgress.style.display = 'none';
            finalMessage.style.display = 'block';
            finalMessage.className = 'error';
            finalMessage.textContent = 'A network error occurred. Please check your log files.';
            this.disabled = false;
            this.innerHTML = '<i class="fas fa-sync-alt"></i> Try Again';
        });
    });

    if (licenseKey) checkForUpdates();
});
</script>