<?php
header('Content-Type: application/json');
require '../db_connect.php';

// হেডার থেকে API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';

if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

// API Key ব্যবহার করে user_id খুঁজে বের করা
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}

$user_id = $setting['user_id'];

// devices টেবিল থেকে ডেটা আনা হচ্ছে
try {
    $stmt = $pdo->prepare("SELECT * FROM devices WHERE user_id = ? ORDER BY id DESC");
    $stmt->execute([$user_id]);
    $devices = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($devices);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.', 'error_details' => $e->getMessage()]);
}
?>