<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

try {
    // transactions টেবিল থেকে ডেটা আনা হচ্ছে
    $sql = "SELECT 
                id, 
                customer_name, 
                customer_email, 
                amount, 
                'BDT' as currency, -- কারেন্সি হার্ডকোড করা হয়েছে, প্রয়োজনে পরিবর্তনযোগ্য
                user_submitted_trxid as transaction_id, 
                status, 
                created_at 
            FROM transactions 
            WHERE user_id = :user_id 
            ORDER BY created_at DESC";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':user_id' => $user_id]);
    $payments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // তারিখকে আরও সুন্দর ফরম্যাটে পাঠানোর জন্য
    foreach ($payments as &$payment) {
        $payment['created_at'] = date("d M, Y, g:i A", strtotime($payment['created_at']));
    }

    echo json_encode($payments);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>