<?php
header('Content-Type: application/json');
require '../db_connect.php';

// হেডার থেকে API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';

if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

// API Key ব্যবহার করে user_id খুঁজে বের করা
$stmt = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt->execute([$api_key]);
$setting = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// অ্যাপ থেকে পাঠানো JSON ডেটা পড়া
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

$device_uid = $data['device_uid'] ?? null;
$status = $data['status'] ?? null;

if (empty($device_uid) || empty($status)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Device UID and status are required.']);
    exit();
}

// ডেটাবেসে ডিভাইসের স্ট্যাটাস আপডেট করা
// এখানে user_id দিয়েও পরীক্ষা করা হচ্ছে যাতে এক ব্যবহারকারী অন্য ব্যবহারকারীর ডিভাইস আপডেট করতে না পারে
try {
    $sql = "UPDATE devices SET status = :status WHERE device_id = :device_id AND user_id = :user_id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'status' => $status,
        'device_id' => $device_uid,
        'user_id' => $user_id
    ]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(['success' => true, 'message' => 'Device status updated successfully.']);
    } else {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'Device not found for this user.']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error during status update.']);
}