<?php
// === ধাপ ১: ব্যবহারকারীর সেশন এবং অথেন্টিকেশন পরীক্ষা করা ===
require 'auth_check.php';
// === ধাপ ২: ডেটাবেস সংযোগ স্থাপন করা ===
require 'db_connect.php';

// সেশন থেকে বর্তমান ব্যবহারকারীর আইডি নেওয়া হচ্ছে
$user_id = $_SESSION['user_id'];
$success_message = '';

// === ধাপ ৩: POST রিকোয়েস্ট হ্যান্ডেল করা (ফর্ম সাবমিট হলে) ===
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // যদি 'generate_key' অ্যাকশন পাঠানো হয়, তবে নতুন API Key তৈরি করা হবে
    if (isset($_POST['action']) && $_POST['action'] === 'generate_key') {
        // একটি নতুন, ইউনিক এবং নিরাপদ API Key তৈরি করা হচ্ছে
        $new_api_key = bin2hex(random_bytes(32));
        
        // ON DUPLICATE KEY UPDATE ব্যবহার করে ডেটাবেসে নতুন কী'টি আপডেট বা ইনসার্ট করা হচ্ছে
        $sql = "INSERT INTO settings (user_id, api_key) VALUES (?, ?) ON DUPLICATE KEY UPDATE api_key = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$user_id, $new_api_key, $new_api_key]);

    } 
    // যদি 'base_url' পাঠানো হয়, তবে সেটি সেভ করা হবে
    elseif (isset($_POST['base_url'])) {
        // ব্যবহারকারীর দেওয়া নতুন Base URL গ্রহণ এবং পরিষ্কার করা
        $new_base_url = trim($_POST['base_url']);
        // URL-এর শেষে কোনো স্ল্যাশ (/) থাকলে তা স্বয়ংক্রিয়ভাবে বাদ দেওয়া হচ্ছে
        $new_base_url = rtrim($new_base_url, '/'); 

        $sql = "INSERT INTO settings (user_id, base_url) VALUES (?, ?) ON DUPLICATE KEY UPDATE base_url = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$user_id, $new_base_url, $new_base_url]);
    }
    
    // সফলভাবে সেভ হওয়ার পর পেজটি রিফ্রেশ করা হচ্ছে এবং একটি সফল বার্তা দেখানো হবে
    header("Location: api_settings.php?success=1");
    exit();
}

// === ধাপ ৪: পেজ লোড হওয়ার সময় ডেটা দেখানো ===

// যদি URL-এ 'success=1' থাকে, তাহলে একটি সফল বার্তা প্রস্তুত করা হচ্ছে
if (isset($_GET['success'])) {
    $success_message = "Settings have been updated successfully!";
}

// ডেটাবেস থেকে বর্তমান API Key এবং Base URL আনা হচ্ছে
$stmt = $pdo->prepare("SELECT api_key, base_url FROM settings WHERE user_id = ?");
$stmt->execute([$user_id]);
$setting = $stmt->fetch(PDO::FETCH_ASSOC);

$api_key = $setting['api_key'] ?? '';
$base_url = $setting['base_url'] ?? '';

// বেস ইউআরএল-এর উপর ভিত্তি করে সম্পূর্ণ এন্ডপয়েন্ট লিঙ্ক তৈরি করা
$endpoint_initiate = !empty($base_url) ? "{$base_url}/initiate_payment.php" : 'Please set and save a Base URL first.';
$endpoint_verify = !empty($base_url) ? "{$base_url}/verify_payment.php" : 'Please set and save a Base URL first.';

// হেডার এবং সাইডবার টেমপ্লেট যুক্ত করা
include 'templates/header.php';
include 'templates/sidebar.php';
?>

<!-- === ধাপ ৫: HTML এবং ফর্ম দেখানো === -->
<div class="page-container">
    <!-- কার্ড ১: API Access Credentials -->
    <div class="content-card api-card">
        <div class="card-header">
            <h3>API Access Credentials</h3>
            <p>Manage your API keys and endpoints for integration</p>
        </div>
        <div class="card-body">
            <div class="form-group">
                <label for="api_key">API Key</label>
                <div class="input-with-actions">
                    <input type="password" id="api_key" value="<?php echo htmlspecialchars($api_key); ?>" readonly>
                    <div class="actions">
                        <button type="button" class="icon-btn" id="toggle-key-visibility" title="Show/Hide Key"><i class="far fa-eye"></i></button>
                        <form action="api_settings.php" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to generate a new API key? This will invalidate the old one and break existing integrations.');">
                            <input type="hidden" name="action" value="generate_key">
                            <button type="submit" class="icon-btn" title="Generate New Key"><i class="fas fa-sync-alt"></i></button>
                        </form>
                        <button type="button" class="icon-btn copy-btn" data-copy-target="api_key" title="Copy Key"><i class="far fa-copy"></i></button>
                    </div>
                </div>
                <small>Your secret API key for authentication. Keep it secure.</small>
            </div>
        </div>
    </div>

    <!-- কার্ড ২: API Endpoints (এডিট করা যাবে) -->
    <div class="content-card api-card">
        <form action="api_settings.php" method="POST">
            <div class="card-header">
                <h3>API Endpoints</h3>
                <p>Your unique API endpoints for integration</p>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="base_url">Base URL</label>
                    <div class="input-with-actions">
                        <input type="text" id="base_url" name="base_url" value="<?php echo htmlspecialchars($base_url); ?>" placeholder="e.g., http://192.168.0.101/dashboard_project/api" required>
                        <button type="button" class="icon-btn copy-btn" data-copy-target="base_url" title="Copy URL"><i class="far fa-copy"></i></button>
                    </div>
                    <small>This is your root API endpoint. Enter the correct public URL of your API folder here.</small>
                </div>
                
                <div class="form-group">
                    <label>Payment Initiation Endpoint</label>
                    <div class="input-with-actions">
                        <input type="text" id="initiate_url" value="<?php echo htmlspecialchars($endpoint_initiate); ?>" readonly>
                        <button type="button" class="icon-btn copy-btn" data-copy-target="initiate_url" title="Copy URL"><i class="far fa-copy"></i></button>
                    </div>
                </div>

                <div class="form-group">
                    <label>Verify Payment Endpoint</label>
                    <div class="input-with-actions">
                        <input type="text" id="verify_url" value="<?php echo htmlspecialchars($endpoint_verify); ?>" readonly>
                        <button type="button" class="icon-btn copy-btn" data-copy-target="verify_url" title="Copy URL"><i class="far fa-copy"></i></button>
                    </div>
                </div>
            </div>
            <div class="settings-actions" style="padding: 20px; border-top: 1px solid #f1f1f1; margin: 0 -20px -20px;">
                <button type="submit" class="btn btn-primary">Save Settings</button>
            </div>
        </form>
    </div>

    <!-- কার্ড ৩: Documentation -->
    <div class="content-card api-card documentation-card">
        <div class="card-header">
            <h3><i class="far fa-file-alt"></i> Documentation</h3>
            <p>Access our comprehensive API documentation for integration details</p>
        </div>
        <div class="card-body">
            <a href="documentation.php" class="btn btn-primary"><i class="far fa-bookmark"></i> View Developer Docs</a>
        </div>
    </div>
</div>

</div> <!-- .main-content বন্ধ করার ট্যাগ -->

<!-- টোস্ট নোটিফিকেশন দেখানোর জন্য HTML -->
<div id="toast-notification"></div>

<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // === ধাপ ৬: জাভাস্ক্রিপ্ট কার্যকারিতা যুক্ত করা ===
    
    // টোস্ট মেসেজ দেখানোর জন্য ফাংশন
    function showToast(message, isSuccess) {
        const toast = document.getElementById('toast-notification');
        if (!toast) return;
        toast.textContent = message;
        toast.className = 'show ' + (isSuccess ? 'success' : 'error');
        setTimeout(() => {
            toast.className = toast.className.replace('show', '');
        }, 3000);
    }

    <?php if ($success_message): ?>
        showToast('<?php echo $success_message; ?>', true);
    <?php endif; ?>

    // "Copy to Clipboard" বাটনের জন্য কার্যকারিতা
    document.querySelectorAll('.copy-btn').forEach(button => {
        button.addEventListener('click', function() {
            const targetId = this.dataset.copyTarget;
            const input = document.getElementById(targetId);
            
            const isPassword = input.type === 'password';
            if (isPassword) input.type = 'text';
            
            input.select();
            input.setSelectionRange(0, 99999); // For mobile devices
            
            try {
                document.execCommand('copy');
                const originalIcon = this.innerHTML;
                this.innerHTML = '<i class="fas fa-check"></i>';
                setTimeout(() => { this.innerHTML = originalIcon; }, 1500);
            } catch (err) {
                alert('Oops, unable to copy');
            }
            
            if (isPassword) input.type = 'password';
            window.getSelection().removeAllRanges();
        });
    });

    // API Key দেখানো/লুকানোর জন্য কার্যকারিতা
    const toggleBtn = document.getElementById('toggle-key-visibility');
    if (toggleBtn) {
        toggleBtn.addEventListener('click', function() {
            const apiKeyInput = document.getElementById('api_key');
            const icon = this.querySelector('i');
            if (apiKeyInput.type === 'password') {
                apiKeyInput.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                apiKeyInput.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
    }
});
</script>
</body>
</html>