<?php
// === ধাপ ১: এরর হ্যান্ডলিং এবং সেশন শুরু করা ===
ob_start();
ini_set('display_errors', 0);
error_reporting(0);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// === ধাপ ২: প্রয়োজনীয় ফাইল এবং ক্লাস যুক্ত করা ===
require __DIR__ . '/vendor/autoload.php';
require __DIR__ . '/db_connect.php';
require __DIR__ . '/auth_check.php';

use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;

// === ধাপ ৩: মূল কোড 실행 (Execution) ===
try {
    if (!isset($_SESSION['user_id'])) {
        throw new Exception("User is not logged in.");
    }
    $user_id = $_SESSION['user_id'];

    // ★★★ পরিবর্তন: একটি অনন্য, একবার-ব্যবহারযোগ্য টোকেন তৈরি করা হচ্ছে ★★★
    $token = bin2hex(random_bytes(32));

    // ★★★ পরিবর্তন: টোকেনটি ডাটাবেসের `users` টেবিলে সেভ করা হচ্ছে ★★★
    $stmt = $pdo->prepare("UPDATE users SET app_auth_token = ? WHERE id = ?");
    $stmt->execute([$token, $user_id]);

    // === ডেটাবেস থেকে Base URL এবং ইমেইল আনা ===
    $stmt_user = $pdo->prepare("
        SELECT u.email, s.base_url 
        FROM users u 
        LEFT JOIN settings s ON u.id = s.user_id 
        WHERE u.id = ?
    ");
    $stmt_user->execute([$user_id]);
    $user_data = $stmt_user->fetch(PDO::FETCH_ASSOC);

    if (!$user_data || empty($user_data['base_url']) || empty($user_data['email'])) {
        throw new Exception("User email or API Base URL not found in settings. Please visit the API Settings page first.");
    }
    $user_email = $user_data['email'];
    $base_url = $user_data['base_url'];
    
    // ★★★ পরিবর্তন: QR কোডের ডেটাতে এখন টোকেন অন্তর্ভুক্ত করা হয়েছে ★★★
    $qr_data = json_encode([
        'baseUrl' => $base_url,
        'email'   => $user_email,
        'token'   => $token
    ]);
    
    // লাইব্রেরির সর্বশেষ সংস্করণ অনুযায়ী কোড
    $qrCode = new QrCode($qr_data, new Encoding('UTF-8'), ErrorCorrectionLevel::High);
    $writer = new PngWriter();
    $result = $writer->write($qrCode);
    
    // === ধাপ ৪: সফলভাবে QR কোড তৈরি হলে ছবিটি পাঠানো ===
    ob_end_clean();
    header('Content-Type: ' . $result->getMimeType());
    echo $result->getString();
    exit();

} catch (Throwable $e) {
    ob_end_clean();
    error_log("CRITICAL QR Code Generation Error: " . $e->getMessage());

    // ব্যবহারকারীকে একটি সাধারণ এরর ইমেজ দেখানো হবে
    header('Content-Type: image/png');
    $im = imagecreate(280, 80);
    imagecolorallocate($im, 244, 247, 250);
    $fg = imagecolorallocate($im, 220, 53, 69);
    imagestring($im, 3, 10, 25, 'ERROR: Could not generate QR Code.', $fg);
    imagestring($im, 3, 10, 45, 'Visit API Settings page first.', $fg);
    imagepng($im);
    imagedestroy($im);
    exit();
}
?>