document.addEventListener('DOMContentLoaded', function() {
    
    // --- সাইডবার টগল করার কোড ---
    const menuIcon = document.getElementById('menu-icon');
    const sidebar = document.getElementById('sidebar');
    const mainContent = document.querySelector('.main-content');

    if (menuIcon) {
        menuIcon.addEventListener('click', function() {
            sidebar.classList.toggle('open');
            mainContent.classList.toggle('shifted');
        });
    }

    
    // --- Modal (পপআপ) নিয়ন্ত্রণ করার কোড ---
    
    // প্রয়োজনীয় এলিমেন্টগুলো সিলেক্ট করা
    const modal = document.getElementById('gatewayModal');
    const openBtn = document.getElementById('openModalBtn');
    const closeBtn = document.querySelector('.modal .close-button');
    const cancelBtn = document.querySelector('.modal .cancel-btn');

    // "+ New gateway" বাটনে ক্লিক করলে Modal খুলবে
    if (openBtn) {
        openBtn.onclick = function() {
            if (modal) {
                modal.style.display = 'block';
            }
        }
    }

    // Close (x) বাটনে ক্লিক করলে Modal বন্ধ হবে
    if (closeBtn) {
        closeBtn.onclick = function() {
            if (modal) {
                modal.style.display = 'none';
            }
        }
    }

    // "Cancel" বাটনে ক্লিক করলে Modal বন্ধ হবে
    if (cancelBtn) {
        cancelBtn.onclick = function() {
            if (modal) {
                modal.style.display = 'none';
            }
        }
    }

    // Modal এর বাইরে ক্লিক করলে Modal বন্ধ হবে
    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    }

    // ★★★ নতুন যুক্ত কোড: Payment Link Copy Functionality ★★★
    
    // টোস্ট নোটিফিকেশনের জন্য একটি div তৈরি করা
    const toast = document.createElement('div');
    toast.id = 'toast-notification';
    document.body.appendChild(toast);

    function showToast(message, isSuccess = true) {
        toast.textContent = message;
        toast.className = isSuccess ? 'show success' : 'show error';
        setTimeout(() => {
            toast.className = toast.className.replace('show', '');
        }, 3000);
    }

    document.querySelectorAll('.action-copy').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const linkId = this.dataset.id;
            const originalHtml = this.innerHTML;
            this.innerHTML = 'Copying...';
            this.disabled = true;

            fetch('get_payment_link.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'id=' + encodeURIComponent(linkId)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success && data.url) {
                    navigator.clipboard.writeText(data.url).then(() => {
                        showToast('Copied successfully!');
                    }).catch(() => {
                        showToast('Failed to copy link.', false);
                    });
                } else {
                    showToast('Could not generate link.', false);
                }
            })
            .catch(() => {
                showToast('An error occurred.', false);
            })
            .finally(() => {
                this.innerHTML = originalHtml;
                this.disabled = false;
            });
        });
    });
});