<?php
// ব্যবহারকারী লগইন করা আছে কিনা তা পরীক্ষা করা
require 'auth_check.php';
// ডেটাবেস সংযোগ ফাইল যুক্ত করা
require 'db_connect.php'; 

// হেডার ও সাইডবার টেমপ্লেট যুক্ত করা
include 'templates/header.php';
include 'templates/sidebar.php';

// সেশন থেকে বর্তমান ব্যবহারকারীর আইডি নেওয়া হচ্ছে
$user_id = $_SESSION['user_id'];

// SELECT কোয়েরিতে WHERE user_id = ? শর্ত যুক্ত করে শুধুমাত্র বর্তমান ব্যবহারকারীর গেটওয়েগুলো আনা হচ্ছে
$stmt = $pdo->prepare("SELECT * FROM gateways WHERE user_id = ? ORDER BY id DESC");
$stmt->execute([$user_id]);
$gateways = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- পেমেন্ট গেটওয়ে পেজের মূল কন্টেন্ট -->
<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">Gateways > List</p>
            <h1 class="page-title">Gateways</h1>
        </div>
        <button class="btn btn-primary" id="openModalBtn">
            <i class="fas fa-plus"></i> New gateway
        </button>
    </div>

    <div class="content-card">
        <div class="card-toolbar">
            <div class="toolbar-left">
                <i class="fas fa-exchange-alt icon-btn"></i>
            </div>
            <div class="toolbar-right">
                <div class="search-box">
                    <i class="fas fa-search"></i>
                    <input type="text" placeholder="Search">
                </div>
            </div>
        </div>

        <table class="data-table">
            <thead>
                <tr>
                    <th><input type="checkbox"></th>
                    <th>Display name <i class="fas fa-chevron-down"></i></th>
                    <th>Currency</th>
                    <th>Status</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($gateways) > 0): ?>
                    <?php foreach ($gateways as $gateway): ?>
                        <tr>
                            <td><input type="checkbox"></td>
                            <td><?php echo htmlspecialchars($gateway['display_name']); ?></td>
                            <td>BDT</td>
                            <td>
                                <label class="toggle-switch">
                                    <input type="checkbox" <?php echo $gateway['status'] ? 'checked' : ''; ?>>
                                    <span class="slider"></span>
                                </label>
                            </td>
                            <td class="actions">
                                <a href="edit_gateway.php?id=<?php echo $gateway['id']; ?>" class="action-edit">
                                    <i class="fas fa-pencil-alt"></i> Edit
                                </a>
                                <a href="#" class="action-delete">
                                    <i class="fas fa-trash-alt"></i> Delete
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" style="text-align:center; padding: 20px;">No gateways have been added yet.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div class="card-footer">
            <div class="pagination-controls">
                <span>Per page</span>
                <select>
                    <option value="10" selected>10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                </select>
            </div>
        </div>
    </div>
</div>

</div> <!-- .main-content বন্ধ করার ট্যাগ -->

<!-- Create Gateway Modal (পপআপ) -->
<div id="gatewayModal" class="modal">
    <div class="modal-content">
        <form action="create_gateway.php" method="POST">
            <div class="modal-header">
                <h2>Create gateway</h2>
                <span class="close-button">&times;</span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="gateway-select">Gateway<span class="required-star">*</span></label>
                    <div class="select-wrapper">
                        <select id="gateway-select" name="gateway_key" required>
                            <option value="">Select an option</option>
                            <option value="bkash_personal">Bkash Personal</option>
                            <option value="nagad_personal">Nagad Personal</option>
                            <option value="rocket_personal">Rocket Personal</option>
                            <option value="upay_personal">Upay Personal</option>
                            <option value="bkash_merchant_tokenized">bKash Marchant (Tokenized)</option>
                            <option value="nagad_merchant">Nagad Marchant</option>
                            <!-- ★★★ নতুন পপআপ অপশন যুক্ত করা হয়েছে ★★★ -->
                            <option value="bkash_merchant_checkout">bKash Marchant (Checkout)</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary cancel-btn">Cancel</button>
                <button type="submit" class="btn btn-primary">Create</button>
            </div>
        </form>
    </div>
</div>

<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
</body>
</html>