<?php
require 'auth_check.php';
require 'db_connect.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // ফর্ম থেকে ডেটা গ্রহণ
    $user_id = $_SESSION['user_id'];
    $product_name = trim($_POST['product_name']);
    $quantity = (int)$_POST['quantity'];
    $product_description = trim($_POST['product_description']) ?: null;
    $currency = $_POST['currency'];
    $amount = (float)$_POST['amount'];
    $expire_date = !empty($_POST['expire_date']) ? $_POST['expire_date'] : null;
    $status = isset($_POST['status']) ? 1 : 0;

    // ডেটাবেসে ডেটা ইনসার্ট করা
    try {
        $sql = "INSERT INTO payment_links (user_id, product_name, product_description, amount, currency, quantity, expire_date, status) 
                VALUES (:user_id, :product_name, :product_description, :amount, :currency, :quantity, :expire_date, :status)";
        
        $stmt = $pdo->prepare($sql);
        
        $stmt->execute([
            ':user_id' => $user_id,
            ':product_name' => $product_name,
            ':product_description' => $product_description,
            ':amount' => $amount,
            ':currency' => $currency,
            ':quantity' => $quantity,
            ':expire_date' => $expire_date,
            ':status' => $status
        ]);

    } catch (PDOException $e) {
        // কোনো সমস্যা হলে এরর দেখানো হবে
        die("Error creating payment link: " . $e->getMessage());
    }

    // সফলভাবে যুক্ত হওয়ার পর payment_links.php পেজে ফিরে যাওয়া
    header("Location: payment_links.php");
    exit();
}
?>