<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) { http_response_code(401); die(json_encode(['success' => false, 'message' => 'API Key is missing.'])); }
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) { http_response_code(403); die(json_encode(['success' => false, 'message' => 'Invalid API Key.'])); }

$user_id = $setting['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $address = trim($_POST['address']) ?: null;
    $city = trim($_POST['city']) ?: null;
    $state = trim($_POST['state']) ?: null;
    $postcode = trim($_POST['postcode']) ?: null;
    $country = trim($_POST['country']) ?: null;

    if (empty($name) || empty($email) || empty($phone)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Required fields are missing.']);
        exit();
    }

    try {
        // একই ইমেইলের গ্রাহক আছে কিনা তা পরীক্ষা করা
        $stmt_check = $pdo->prepare("SELECT id FROM transactions WHERE user_id = ? AND customer_email = ?");
        $stmt_check->execute([$user_id, $email]);
        if ($stmt_check->fetch()) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'A customer with this email already exists.']);
            exit();
        }

        $sql = "INSERT INTO transactions (user_id, unique_id, amount, customer_name, customer_email, phone, address, city, state, postcode, country, status, meta_data) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt_insert = $pdo->prepare($sql);
        $stmt_insert->execute([
            $user_id, 'manual_api_' . sha1(uniqid(rand(), true)), 0, $name, $email, $phone,
            $address, $city, $state, $postcode, $country, 'completed',
            json_encode(['source' => 'manual_api_entry'])
        ]);

        echo json_encode(['success' => true, 'message' => 'Customer added successfully.']);

    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
}
?>