<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

$link_id = $_POST['id'] ?? null;

if ($link_id) {
    try {
        $stmt = $pdo->prepare("DELETE FROM payment_links WHERE id = :id AND user_id = :user_id");
        $stmt->execute([':id' => $link_id, ':user_id' => $user_id]);
        if($stmt->rowCount() > 0){
            echo json_encode(['success' => true, 'message' => 'Payment link deleted successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Link not found or permission denied.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Database error.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Link ID not provided.']);
}
?>