<?php
require 'auth_check.php';
require 'db_connect.php';
include 'templates/header.php';
include 'templates/sidebar.php';

// Fetch credit transaction history for the logged-in user
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare(
    "SELECT ct.transaction_date, ct.description, ct.credits_deducted, ct.cost_usd, t.user_submitted_trxid
     FROM credit_transactions ct
     LEFT JOIN transactions t ON ct.payment_transaction_id = t.id
     WHERE ct.user_id = ? 
     ORDER BY ct.transaction_date DESC"
);
$stmt->execute([$user_id]);
$credit_history = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="page-container">
    <div class="billing-container">
        <aside class="billing-sidebar">
            <nav>
                <ul>
                    <li><a href="billing.php">Billing</a></li>
                    <li class="active"><a href="billing_history.php">Billing Histories</a></li>
                </ul>
            </nav>
        </aside>
        <main class="billing-main">
            <div class="content-card">
                <div class="card-header">
                    <h3>Credit History</h3>
                </div>
                <div class="card-body">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Description</th>
                                <th>Gateway Trx ID</th>
                                <th>Credits Used</th>
                                <th>Cost (USD)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (count($credit_history) > 0): ?>
                                <?php foreach ($credit_history as $entry): ?>
                                    <tr>
                                        <td><?php echo date("d M Y, H:i:s", strtotime($entry['transaction_date'])); ?></td>
                                        <td><?php echo htmlspecialchars($entry['description']); ?></td>
                                        <td><?php echo htmlspecialchars($entry['user_submitted_trxid'] ?? 'N/A'); ?></td>
                                        <td><?php echo number_format($entry['credits_deducted'], 2); ?></td>
                                        <td>$<?php echo number_format($entry['cost_usd'], 4); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="5" style="text-align:center; padding: 20px;">No credit history found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </main>
    </div>
</div>

</div>
<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
</body>
</html>
