<?php
header('Content-Type: application/json');
require '../db_connect.php';

$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';

if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// ★★★ সমাধান: এখন সব কলাম সিলেক্ট করা হচ্ছে (*) যাতে মার্চেন্টের সব তথ্য অ্যাপে যায় ★★★
$stmt_gateways = $pdo->prepare("SELECT * FROM gateways WHERE user_id = ? ORDER BY id DESC");
$stmt_gateways->execute([$user_id]);
$gateways = $stmt_gateways->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($gateways);
?>