<?php
header('Content-Type: application/json');
require '../db_connect.php';

$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) { http_response_code(401); die(json_encode(['success' => false, 'message' => 'API Key is missing.'])); }

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) { http_response_code(403); die(json_encode(['success' => false, 'message' => 'Invalid API Key.'])); }

$user_id = $setting['user_id'];

// ★★★ পরিবর্তন এখানে: SQL কোয়েরিতে 'expire_date' যুক্ত করা হয়েছে ★★★
$stmt = $pdo->prepare("SELECT id, product_name, product_description, amount, currency, quantity, status, expire_date FROM payment_links WHERE user_id = ? AND is_default = 0 ORDER BY id DESC");
$stmt->execute([$user_id]);
$links = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($links);
?>