<?php
require 'auth_check.php';
require 'db_connect.php';

$user_id = $_SESSION['user_id'];

// --- ধাপ ১: ব্যবহারকারীর টাইমজোন খুঁজে বের করা ---
$stmt_settings = $pdo->prepare("SELECT timezone FROM brand_settings WHERE user_id = ?");
$stmt_settings->execute([$user_id]);
$settings = $stmt_settings->fetch(PDO::FETCH_ASSOC);
// ব্যবহারকারীর সেট করা টাইমজোন নেওয়া হচ্ছে, সেট করা না থাকলে ডিফল্ট হিসেবে 'Asia/Dhaka' ব্যবহার করা হবে
$user_timezone = $settings['timezone'] ?? 'Asia/Dhaka';

// --- ধাপ ২: ব্যবহারকারীর টাইমজোন অনুযায়ী তারিখ গণনা করা ---
// PHP স্ক্রিপ্টের জন্য ব্যবহারকারীর টাইমজোন সেট করা হচ্ছে
date_default_timezone_set($user_timezone);

define('BDT_TO_USD_RATE', 0.0085);

// ফাংশন দুটি এখন UTC সময় অনুযায়ী ডেটা খুঁজবে
function get_completed_payment_data($pdo, $user_id, $start_date_utc, $end_date_utc) {
    $sql = "SELECT COALESCE(SUM(amount), 0) as total_amount, COUNT(id) as payment_count 
            FROM transactions 
            WHERE user_id = ? AND status = 'completed' AND created_at BETWEEN ? AND ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$user_id, $start_date_utc, $end_date_utc]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

function get_total_initiated_payments($pdo, $user_id, $start_date_utc, $end_date_utc) {
    $sql = "SELECT COUNT(id) as total_count FROM transactions WHERE user_id = ? AND created_at BETWEEN ? AND ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$user_id, $start_date_utc, $end_date_utc]);
    return $stmt->fetchColumn() ?? 0;
}

// --- ধাপ ৩: লোকাল সময়কে UTC-তে রূপান্তর করে ডেটা আনা ---
$user_tz_obj = new DateTimeZone($user_timezone);
$utc_tz_obj = new DateTimeZone('UTC');

function get_utc_range($start_str, $end_str, $user_tz_obj, $utc_tz_obj) {
    $start = new DateTime($start_str, $user_tz_obj);
    $end = new DateTime($end_str, $user_tz_obj);
    return [
        $start->setTimezone($utc_tz_obj)->format('Y-m-d H:i:s'),
        $end->setTimezone($utc_tz_obj)->format('Y-m-d H:i:s')
    ];
}

// প্রতিটি সময়কালের জন্য UTC রেঞ্জ তৈরি করা হচ্ছে
list($today_start, $today_end) = get_utc_range('today 00:00:00', 'today 23:59:59', $user_tz_obj, $utc_tz_obj);
list($yesterday_start, $yesterday_end) = get_utc_range('yesterday 00:00:00', 'yesterday 23:59:59', $user_tz_obj, $utc_tz_obj);
list($this_week_start, $this_week_end) = get_utc_range('monday this week 00:00:00', 'sunday this week 23:59:59', $user_tz_obj, $utc_tz_obj);
list($last_week_start, $last_week_end) = get_utc_range('monday last week 00:00:00', 'sunday last week 23:59:59', $user_tz_obj, $utc_tz_obj);
list($this_month_start, $this_month_end) = get_utc_range('first day of this month 00:00:00', 'last day of this month 23:59:59', $user_tz_obj, $utc_tz_obj);
list($last_month_start, $last_month_end) = get_utc_range('first day of last month 00:00:00', 'last day of last month 23:59:59', $user_tz_obj, $utc_tz_obj);
list($this_year_start, $this_year_end) = get_utc_range('first day of January this year 00:00:00', 'last day of December this year 23:59:59', $user_tz_obj, $utc_tz_obj);
list($last_year_start, $last_year_end) = get_utc_range('first day of January last year 00:00:00', 'last day of December last year 23:59:59', $user_tz_obj, $utc_tz_obj);

// UTC সময় ব্যবহার করে ডেটা আনা
$today_completed = get_completed_payment_data($pdo, $user_id, $today_start, $today_end);
$today_initiated = get_total_initiated_payments($pdo, $user_id, $today_start, $today_end);
$yesterday_completed = get_completed_payment_data($pdo, $user_id, $yesterday_start, $yesterday_end);
$yesterday_initiated = get_total_initiated_payments($pdo, $user_id, $yesterday_start, $yesterday_end);
$this_week_completed = get_completed_payment_data($pdo, $user_id, $this_week_start, $this_week_end);
$this_week_initiated = get_total_initiated_payments($pdo, $user_id, $this_week_start, $this_week_end);
$last_week_completed = get_completed_payment_data($pdo, $user_id, $last_week_start, $last_week_end);
$last_week_initiated = get_total_initiated_payments($pdo, $user_id, $last_week_start, $last_week_end);
$this_month_completed = get_completed_payment_data($pdo, $user_id, $this_month_start, $this_month_end);
$this_month_initiated = get_total_initiated_payments($pdo, $user_id, $this_month_start, $this_month_end);
$last_month_completed = get_completed_payment_data($pdo, $user_id, $last_month_start, $last_month_end);
$last_month_initiated = get_total_initiated_payments($pdo, $user_id, $last_month_start, $last_month_end);
$this_year_completed = get_completed_payment_data($pdo, $user_id, $this_year_start, $this_year_end);
$this_year_initiated = get_total_initiated_payments($pdo, $user_id, $this_year_start, $this_year_end);
$last_year_completed = get_completed_payment_data($pdo, $user_id, $last_year_start, $last_year_end);
$last_year_initiated = get_total_initiated_payments($pdo, $user_id, $last_year_start, $last_year_end);


function render_report_card($title, $completed_data, $initiated_count) {
    $amount_in_usd = $completed_data['total_amount'] * BDT_TO_USD_RATE;
    $completed_count = $completed_data['payment_count'];
    $success_rate = ($initiated_count > 0) ? ($completed_count / $initiated_count) * 100 : 0;
    $success_rate_text = number_format($success_rate, 1) . '% success';

    echo '<div class="report-card">
          <div class="card-header"><span class="card-title">' . htmlspecialchars($title) . '</span><i class="far fa-calendar-alt"></i></div>
          <div class="card-body">
              <h2 class="amount">$'. number_format($amount_in_usd, 2) .'</h2>
              <p class="stats">' . $completed_count . ' payments completed &bull; <span class="success-rate">' . $success_rate_text . '</span></p>
          </div>
        </div>';
}

include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <div class="page-header">
        <h1 class="page-title">Reports</h1>
        <div class="report-filters">
            <button class="btn btn-secondary"><i class="far fa-calendar-alt"></i> Daily</button>
            <button class="btn btn-secondary"><i class="far fa-calendar-alt"></i> Weekly</button>
            <button class="btn btn-secondary"><i class="far fa-calendar-alt"></i> Monthly</button>
            <button class="btn btn-secondary"><i class="fas fa-chart-line"></i> Yearly</button>
            <button class="btn btn-primary"><i class="fas fa-sliders-h"></i> Custom Range</button>
        </div>
    </div>
    <div class="financial-report-bar">
        <span>Financial Report: <?php echo date('M j, Y', strtotime('first day of this month')) . ' - ' . date('M j, Y', strtotime('last day of this month')); ?></span>
        <button class="btn btn-secondary">Monthly View</button>
    </div>
    <div class="report-grid">
        <?php render_report_card('Today', $today_completed, $today_initiated); ?>
        <?php render_report_card('Yesterday', $yesterday_completed, $yesterday_initiated); ?>
        <?php render_report_card('This Week', $this_week_completed, $this_week_initiated); ?>
        <?php render_report_card('Last Week', $last_week_completed, $last_week_initiated); ?>
        <?php render_report_card('This Month', $this_month_completed, $this_month_initiated); ?>
        <?php render_report_card('Last Month', $last_month_completed, $last_month_initiated); ?>
        <?php render_report_card('This Year', $this_year_completed, $this_year_initiated); ?>
        <?php render_report_card('Last Year', $last_year_completed, $last_year_initiated); ?>
    </div>
</div>

</div>
<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
</body>
</html>