<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// Handle POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $link_id = $_POST['link_id'] ?? null;
    $product_name = trim($_POST['product_name']);
    $quantity = (int)$_POST['quantity'];
    $amount = (float)$_POST['amount'];
    
    if (empty($link_id) || empty($product_name) || empty($quantity) || empty($amount)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Required fields are missing.']);
        exit();
    }
    
    $expire_date = !empty(trim($_POST['expire_date'])) ? trim($_POST['expire_date']) : null;

    try {
        $sql = "UPDATE payment_links SET 
                    product_name = :p_name, 
                    product_description = :p_desc, 
                    amount = :amount, 
                    currency = :currency, 
                    quantity = :qty, 
                    expire_date = :expire_date, 
                    status = :status
                WHERE id = :link_id AND user_id = :user_id";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':p_name' => $product_name,
            ':p_desc' => trim($_POST['product_description']) ?: null,
            ':amount' => $amount,
            ':currency' => $_POST['currency'],
            ':qty' => $quantity,
            ':expire_date' => $expire_date,
            ':status' => $_POST['status'] === '1' ? 1 : 0,
            ':link_id' => $link_id,
            ':user_id' => $user_id
        ]);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true, 'message' => 'Payment link updated successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Link not found or no changes were made.']);
        }

    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method Not Allowed.']);
}
?>