<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting_user = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting_user) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting_user['user_id'];

$upload_dir = "../uploads/logos/{$user_id}/";
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// Fetch current logos to delete old files if new ones are uploaded
$stmt_fetch = $pdo->prepare("SELECT primary_logo, round_logo, favicon FROM brand_logos WHERE user_id = ?");
$stmt_fetch->execute([$user_id]);
$current_logos = $stmt_fetch->fetch(PDO::FETCH_ASSOC) ?: [];

function handle_upload($file_key, $upload_dir, $current_path) {
    global $_POST;
    // Check if removal is requested
    if (!empty($_POST['remove_' . $file_key]) && $_POST['remove_' . $file_key] === '1') {
        if ($current_path && file_exists("../" . $current_path)) {
            unlink("../" . $current_path);
        }
        return null; // Return null to clear the database field
    }

    // Handle file upload
    if (isset($_FILES[$file_key]) && $_FILES[$file_key]['error'] === UPLOAD_ERR_OK) {
        // Delete old file first
        if ($current_path && file_exists("../" . $current_path)) {
            unlink("../" . $current_path);
        }
        $file = $_FILES[$file_key];
        $file_ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $new_filename = $file_key . '_' . time() . '.' . $file_ext;
        $destination = $upload_dir . $new_filename;
        if (move_uploaded_file($file['tmp_name'], $destination)) {
            // Return path relative to the project root, not the api folder
            return str_replace('../', '', $destination);
        }
    }
    return $current_path; // Return old path if no new file/action
}

$primary_logo_path = handle_upload('primary_logo', $upload_dir, $current_logos['primary_logo'] ?? null);
$round_logo_path = handle_upload('round_logo', $upload_dir, $current_logos['round_logo'] ?? null);
$favicon_path = handle_upload('favicon', $upload_dir, $current_logos['favicon'] ?? null);

try {
    $sql = "INSERT INTO brand_logos (user_id, primary_logo, round_logo, favicon) 
            VALUES (:user_id, :p_logo, :r_logo, :fav)
            ON DUPLICATE KEY UPDATE 
            primary_logo = :p_logo, round_logo = :r_logo, favicon = :fav";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':user_id' => $user_id, 
        ':p_logo' => $primary_logo_path, 
        ':r_logo' => $round_logo_path, 
        ':fav' => $favicon_path
    ]);

    echo json_encode(['success' => true, 'message' => 'Logos updated successfully!']);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}