<?php
require 'auth_check.php';
require 'db_connect.php';

$link_id = $_GET['id'] ?? null;
$user_id = $_SESSION['user_id'];

if (!$link_id) {
    header("Location: payment_links.php");
    exit();
}

// POST রিকোয়েস্ট হ্যান্ডেল করে ডেটা আপডেট করা
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // ফর্ম থেকে আপডেট করা ডেটা গ্রহণ
    $product_name = trim($_POST['product_name']);
    $quantity = (int)$_POST['quantity'];
    $product_description = trim($_POST['product_description']) ?: null;
    $currency = $_POST['currency'];
    $amount = (float)$_POST['amount'];
    $expire_date = !empty($_POST['expire_date']) ? $_POST['expire_date'] : null;
    $status = isset($_POST['status']) ? 1 : 0;

    // UPDATE কোয়েরি
    $sql = "UPDATE payment_links SET 
                product_name = :product_name, product_description = :product_description,
                amount = :amount, currency = :currency, quantity = :quantity,
                expire_date = :expire_date, status = :status
            WHERE id = :id AND user_id = :user_id";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':product_name' => $product_name,
        ':product_description' => $product_description,
        ':amount' => $amount,
        ':currency' => $currency,
        ':quantity' => $quantity,
        ':expire_date' => $expire_date,
        ':status' => $status,
        ':id' => $link_id,
        ':user_id' => $user_id
    ]);

    header("Location: payment_links.php");
    exit();
}

// ডেটাবেস থেকে বর্তমান তথ্য আনা হচ্ছে
$stmt = $pdo->prepare("SELECT * FROM payment_links WHERE id = ? AND user_id = ?");
$stmt->execute([$link_id, $user_id]);
$link = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$link) {
    // যদি লিঙ্কটি খুঁজে না পাওয়া যায় বা এটি এই ব্যবহারকারীর না হয়
    header("Location: payment_links.php");
    exit();
}

include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">Payment Links > Edit</p>
            <h1 class="page-title">Edit Payment Link</h1>
        </div>
    </div>

    <div class="content-card">
        <form action="edit_payment_link.php?id=<?php echo $link['id']; ?>" method="POST">
            <div class="form-section">
                <div class="form-row">
                    <div class="form-group half-width">
                        <label for="product_name">Product name<span class="required-star">*</span></label>
                        <input type="text" id="product_name" name="product_name" value="<?php echo htmlspecialchars($link['product_name']); ?>" required>
                    </div>
                    <div class="form-group half-width">
                        <label for="quantity">Quantity<span class="required-star">*</span></label>
                        <input type="number" id="quantity" name="quantity" value="<?php echo htmlspecialchars($link['quantity']); ?>" required>
                    </div>
                </div>

                <div class="form-group">
                    <label for="product_description">Product description</label>
                    <textarea id="product_description" name="product_description" rows="4"><?php echo htmlspecialchars($link['product_description']); ?></textarea>
                </div>

                <div class="form-row">
                    <div class="form-group third-width">
                        <label for="currency">Currency</label>
                        <div class="select-wrapper">
                            <select id="currency" name="currency">
                                <option value="BDT" <?php echo ($link['currency'] === 'BDT') ? 'selected' : ''; ?>>BDT</option>
                                <option value="USD" <?php echo ($link['currency'] === 'USD') ? 'selected' : ''; ?>>USD</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group third-width">
                        <label for="amount">Amount<span class="required-star">*</span></label>
                        <div class="input-with-prefix">
                            <span>BDT</span>
                            <input type="number" step="0.01" id="amount" name="amount" value="<?php echo htmlspecialchars($link['amount']); ?>" required>
                        </div>
                    </div>
                    <div class="form-group third-width">
                        <label for="expire_date">Expire Date</label>
                        <input type="date" id="expire_date" name="expire_date" value="<?php echo htmlspecialchars($link['expire_date']); ?>">
                    </div>
                </div>

                <div class="form-group">
                    <label>Status<span class="required-star">*</span></label>
                    <label class="toggle-switch">
                        <input type="checkbox" name="status" value="1" <?php echo $link['status'] ? 'checked' : ''; ?>>
                        <span class="slider"></span>
                    </label>
                </div>
            </div>

            <div class="form-actions" style="border-top: 1px solid #f1f1f1; padding-top: 20px; margin-top: 20px;">
                <button type="submit" class="btn btn-primary">Save Changes</button>
                <a href="payment_links.php" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>

</div> <!-- .main-content বন্ধ করার ট্যাগ -->

<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
</body>
</html>