<?php
require 'auth_check.php';
require 'db_connect.php'; 

include 'templates/header.php';
include 'templates/sidebar.php';

$php_path = '/usr/local/bin/php';
if (defined('PHP_BINARY') && is_executable(PHP_BINARY) && strpos(PHP_BINARY, 'lsphp') === false) {
    $php_path = PHP_BINARY;
}
$script_path = __DIR__ . '/run_updater.php';
$log_path = __DIR__ . '/cron_log.txt';
$cron_command_only = "{$php_path} -q {$script_path} >> {$log_path} 2>&1";
?>

<div class="page-container">
    <div class="page-header"><h1 class="page-title">Application Updater</h1></div>

    <!-- ★★★ নতুন ডিজাইন করা আপডেট স্ট্যাটাস সেকশন ★★★ -->
    <div class="content-card" style="margin-bottom: 20px;">
        <h3>Update Status</h3>
        <p>Your current version: <strong><?php echo defined('APP_VERSION') ? htmlspecialchars(APP_VERSION) : 'N/A'; ?></strong></p>
        <div id="update-status-area">
            <p id="status-text">Checking for new updates...</p>
            <!-- ম্যানুয়াল আপডেটের জন্য এই অংশটি JavaScript দিয়ে দেখানো হবে -->
            <div id="manual-update-box" style="display: none; border: 1px solid #0d6efd; padding: 20px; border-radius: 8px; margin-top: 15px; background-color: #e9efff;">
                <h4>A new version is ready to be installed!</h4>
                <p>New Version: <strong id="new-version-number"></strong></p>
                <button id="install-now-btn" class="btn btn-primary"><i class="fas fa-download"></i> Install Now</button>
            </div>
            <!-- ইনস্টলেশন პროგრెస్ দেখানোর জন্য -->
            <div id="install-progress" style="display: none; margin-top: 15px;">
                <p id="progress-text">Installing update... Please wait.</p>
                <div class="progress-bar-container" style="display: block;"><div id="progress-bar" class="progress-bar" style="width: 0%;">0%</div></div>
            </div>
        </div>
        <div id="final-message" style="margin-top: 15px; padding: 10px; border-radius: 8px; display: none;"></div>
    </div>

    <!-- Cron Job সেকশন (অপরিবর্তিত) -->
    <div class="content-card">
        <h3>Automatic Updates Setup (Cron Job)</h3>
        <p>To enable automatic updates, set up a Cron Job on your server. We recommend running it every 5 minutes.</p>
        <div class="form-group" style="margin-top: 20px;">
            <label>Timing (Common Settings)</label>
            <pre><code>Once Per Five Minutes (*/5 * * * *)</code></pre>
        </div>
        <div class="form-group">
            <label>Command</label>
            <pre><code><?php echo htmlspecialchars($cron_command_only); ?></code></pre>
        </div>
    </div>
</div>

<style>
    #final-message.success { background-color: #d1e7dd; color: #0f5132; }
    #final-message.error { background-color: #f8d7da; color: #842029; }
    .progress-bar-container { display: none; width: 100%; background-color: #f3f3f3; border-radius: 8px; }
    .progress-bar { width: 0%; height: 25px; background-color: #0d6efd; text-align: center; line-height: 25px; color: white; border-radius: 8px; transition: width 0.4s ease; }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusText = document.getElementById('status-text');
    const manualUpdateBox = document.getElementById('manual-update-box');
    const newVersionDisplay = document.getElementById('new-version-number');
    const installBtn = document.getElementById('install-now-btn');
    const installProgress = document.getElementById('install-progress');
    const finalMessage = document.getElementById('final-message');
    const progressBar = document.getElementById('progress-bar');
    const progressText = document.getElementById('progress-text');

    const licenseKey = '<?php echo defined('LICENSE_KEY') ? LICENSE_KEY : ''; ?>';
    const currentVersion = '<?php echo defined('APP_VERSION') ? APP_VERSION : '0.0.0'; ?>';

    function checkForUpdates() {
        fetch('manual_update_handler.php?action=check', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({'license_key': licenseKey, 'current_version': currentVersion})
        })
        .then(response => response.json())
        .then(data => {
            if (data.update_available) {
                if (data.update_type === 'manual') {
                    statusText.textContent = 'A manual update is available.';
                    newVersionDisplay.textContent = data.version;
                    manualUpdateBox.style.display = 'block';
                } else {
                    statusText.innerHTML = `An automatic update to version <strong>${data.version}</strong> will be installed soon via the cron job.`;
                }
            } else if (data.update_available === false) {
                statusText.textContent = 'Your application is up-to-date.';
                statusText.style.color = '#198754';
            } else {
                throw new Error(data.message || 'Invalid response');
            }
        })
        .catch(error => {
            statusText.textContent = 'Could not check for updates: ' + error.message;
            statusText.style.color = '#dc3545';
        });
    }

    installBtn.addEventListener('click', function() {
        this.disabled = true;
        manualUpdateBox.style.display = 'none';
        statusText.style.display = 'none';
        installProgress.style.display = 'block';

        // সিমুলেটেড პროგრెస్ বার
        let width = 10;
        const interval = setInterval(() => {
            if (width < 90) {
                width += Math.floor(Math.random() * 10);
                progressBar.style.width = width + '%';
                progressBar.textContent = width + '%';
            }
        }, 300);

        // ইনস্টলেশন শুরু করার জন্য AJAX কল
        fetch('manual_update_handler.php?action=install', { method: 'POST' })
        .then(response => response.json())
        .then(data => {
            clearInterval(interval);
            progressBar.style.width = '100%';
            progressBar.textContent = '100%';
            installProgress.style.display = 'none';
            finalMessage.style.display = 'block';

            if (data.success) {
                finalMessage.className = 'success';
                finalMessage.textContent = data.message + ' The page will reload shortly.';
                setTimeout(() => { window.location.reload(); }, 3000);
            } else {
                finalMessage.className = 'error';
                finalMessage.textContent = 'Update Failed: ' + (data.message || 'Unknown error.');
                this.disabled = false;
            }
        })
        .catch(error => {
            clearInterval(interval);
            installProgress.style.display = 'none';
            finalMessage.style.display = 'block';
            finalMessage.className = 'error';
            finalMessage.textContent = 'A network error occurred during installation.';
            this.disabled = false;
        });
    });

    if (licenseKey) checkForUpdates();
});
</script>