<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) { http_response_code(401); die(json_encode(['success' => false, 'message' => 'API Key is missing.'])); }

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) { http_response_code(403); die(json_encode(['success' => false, 'message' => 'Invalid API Key.'])); }

$user_id = $setting['user_id'];

try {
    // credit_transactions টেবিল থেকে ডেটা আনা হচ্ছে
    // transactions টেবিলের সাথে JOIN করে গেটওয়ের ট্রানজেকশন আইডি আনা হচ্ছে
    $sql = "SELECT 
                ct.id,
                ct.transaction_date,
                ct.description,
                ct.credits_deducted,
                ct.cost_usd,
                t.user_submitted_trxid
            FROM credit_transactions ct
            LEFT JOIN transactions t ON ct.payment_transaction_id = t.id
            WHERE ct.user_id = :user_id
            ORDER BY ct.transaction_date DESC";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':user_id' => $user_id]);
    $history = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // তারিখকে পাঠযোগ্য ফরম্যাটে রূপান্তর
    foreach ($history as &$item) {
        $item['transaction_date'] = date("d M, Y, g:i A", strtotime($item['transaction_date']));
        // যদি কোনো গেটওয়ে ট্রানজেকশন আইডি না থাকে
        if (empty($item['user_submitted_trxid'])) {
            $item['user_submitted_trxid'] = 'N/A';
        }
    }

    echo json_encode($history);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>