<?php
header('Content-Type: application/json');
require '../db_connect.php';

$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting_user = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting_user) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting_user['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? null;

    try {
        if ($action === 'save_general') {
            $site_name = trim($_POST['site_name']);
            $timezone = $_POST['timezone'];
            $default_currency = $_POST['default_currency'];
            $currency_symbol = ($default_currency === 'BDT') ? '৳' : '$';
            $default_language = $_POST['default_language'];
            $week_starts_on = $_POST['week_starts_on'];

            $sql = "INSERT INTO brand_settings (user_id, site_name, timezone, default_currency, currency_symbol, default_language, week_starts_on) 
                    VALUES (:uid, :s_name, :tz, :def_curr, :curr_sym, :def_lang, :w_start)
                    ON DUPLICATE KEY UPDATE 
                    site_name = :s_name, timezone = :tz, default_currency = :def_curr, 
                    currency_symbol = :curr_sym, default_language = :def_lang, week_starts_on = :w_start";
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':uid' => $user_id, ':s_name' => $site_name, ':tz' => $timezone, 
                ':def_curr' => $default_currency, ':curr_sym' => $currency_symbol, 
                ':def_lang' => $default_language, ':w_start' => $week_starts_on
            ]);
            echo json_encode(['success' => true, 'message' => 'General settings saved successfully!']);

        } elseif ($action === 'save_branding') {
            $colors = [
                'user_id' => $user_id, 'global_text_color' => $_POST['global_text_color'],
                'primary_button_color' => $_POST['primary_button_color'], 'button_text_color' => $_POST['button_text_color'],
                'button_hover_color' => $_POST['button_hover_color'], 'button_hover_text_color' => $_POST['button_hover_text_color'],
                'navigation_background' => $_POST['navigation_background'], 'navigation_text_color' => $_POST['navigation_text_color'],
                'active_tab_color' => $_POST['active_tab_color'], 'active_tab_text_color' => $_POST['active_tab_text_color']
            ];
            $sql_colors = "INSERT INTO brand_colors (user_id, global_text_color, primary_button_color, button_text_color, button_hover_color, button_hover_text_color, navigation_background, navigation_text_color, active_tab_color, active_tab_text_color)
                           VALUES (:user_id, :global_text_color, :primary_button_color, :button_text_color, :button_hover_color, :button_hover_text_color, :navigation_background, :navigation_text_color, :active_tab_color, :active_tab_text_color)
                           ON DUPLICATE KEY UPDATE 
                           global_text_color = :global_text_color, primary_button_color = :primary_button_color, button_text_color = :button_text_color, 
                           button_hover_color = :button_hover_color, button_hover_text_color = :button_hover_text_color, navigation_background = :navigation_background, 
                           navigation_text_color = :navigation_text_color, active_tab_color = :active_tab_color, active_tab_text_color = :active_tab_text_color";
            $stmt = $pdo->prepare($sql_colors);
            $stmt->execute($colors);
            echo json_encode(['success' => true, 'message' => 'Branding settings saved successfully!']);

        } elseif ($action === 'save_business') {
            $details = [
                'user_id' => $user_id, 'street_address' => trim($_POST['street_address']),
                'city' => trim($_POST['city']), 'postal_code' => trim($_POST['postal_code']),
                'country' => $_POST['country']
            ];
            $sql_details = "INSERT INTO business_details (user_id, street_address, city, postal_code, country)
                            VALUES (:user_id, :street_address, :city, :postal_code, :country)
                            ON DUPLICATE KEY UPDATE 
                            street_address = :street_address, city = :city, postal_code = :postal_code, country = :country";
            $stmt = $pdo->prepare($sql_details);
            $stmt->execute($details);
            echo json_encode(['success' => true, 'message' => 'Business details saved successfully!']);

        } elseif ($action === 'save_contact') {
            $support_info = [
                'user_id' => $user_id, 'support_phone' => trim($_POST['support_phone']),
                'support_email' => trim($_POST['support_email']), 'support_website' => trim($_POST['support_website'])
            ];
            $sql_support = "INSERT INTO support_details (user_id, support_phone, support_email, support_website)
                            VALUES (:user_id, :support_phone, :support_email, :support_website)
                            ON DUPLICATE KEY UPDATE 
                            support_phone = :support_phone, support_email = :support_email, support_website = :support_website";
            $stmt = $pdo->prepare($sql_support);
            $stmt->execute($support_info);
            echo json_encode(['success' => true, 'message' => 'Contact info saved successfully!']);
        } else {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'No valid action specified.']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}