<?php
// run_updater.php (Cron Job Script - v2.0 with Automatic/Manual logic)

// নিশ্চিত করা হচ্ছে যে এই স্ক্রিপ্টটি শুধুমাত্র কমান্ড লাইন (Cron Job) থেকে চালানো হচ্ছে
if (php_sapi_name() !== 'cli' && substr(php_sapi_name(), 0, 3) !== 'cgi') {
    die("This script can only be run from the command line (Cron Job).");
}

// মূল আপডেট লজিক ফাইলটি যুক্ত করা
require_once __DIR__ . '/updater_logic.php';
// কনফিগ ফাইল থেকে তথ্য লোড করা
require_once __DIR__ . '/config.php';

// লগ মেসেজ লেখার জন্য ফাংশন
function cron_log($message) {
    $log_file = __DIR__ . '/cron_log.txt';
    file_put_contents($log_file, date('[Y-m-d H:i:s] ') . $message . "\n", FILE_APPEND);
}

cron_log("Cron job started. Checking for updates...");

try {
    $central_api_url = 'https://settings.top/dashboard_project/api/check_update.php';
    
    // cURL দিয়ে কেন্দ্রীয় সার্ভারে আপডেটের জন্য চেক করা
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $central_api_url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'license_key' => LICENSE_KEY, 
        'current_version' => APP_VERSION
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    
    $update_info = json_decode($response, true);

    if (!$update_info || !isset($update_info['update_available'])) {
        throw new Exception("Invalid response from update server.");
    }
    
    // ★★★ মূল লজিক: আপডেট পাওয়া গেলে এবং টাইপ 'automatic' হলেই কেবল ইনস্টল হবে ★★★
    if ($update_info['update_available'] && isset($update_info['update_type']) && $update_info['update_type'] === 'automatic') {
        cron_log("Automatic update found to version " . $update_info['version'] . ". Starting installation...");
        
        // updater_logic.php থেকে মূল আপডেট ফাংশনটি কল করা
        $result = perform_update(); 
        
        // আপডেটের ফলাফল লগ করা
        cron_log($result['message']);
        
    } else if ($update_info['update_available']) {
        cron_log("Manual update to version " . $update_info['version'] . " is available. User action required.");
    } else {
        cron_log("No new updates found. Application is up-to-date.");
    }

} catch (Exception $e) {
    cron_log("!!! CRON JOB FAILED: " . $e->getMessage());
}

echo "Cron job finished.\n";