<?php
header('Content-Type: application/json');
require '../db_connect.php';

// API Key Authentication
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);
if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// Handle POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_name = trim($_POST['product_name']);
    $quantity = (int)$_POST['quantity'];
    $amount = (float)$_POST['amount'];
    
    if (empty($product_name) || empty($quantity) || empty($amount)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Required fields are missing.']);
        exit();
    }
    
    // ★★★ পরিবর্তন এখানে ★★★
    // expire_date ভ্যালুটি খালি থাকলে null হিসেবে সেট করা হচ্ছে
    $expire_date = !empty(trim($_POST['expire_date'])) ? trim($_POST['expire_date']) : null;

    try {
        // ★★★ পরিবর্তন এখানে: SQL কোয়েরিতে expire_date যুক্ত করা হয়েছে ★★★
        $sql = "INSERT INTO payment_links (user_id, product_name, product_description, amount, currency, quantity, expire_date, status) 
                VALUES (:user_id, :p_name, :p_desc, :amount, :currency, :qty, :expire_date, :status)";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':user_id' => $user_id,
            ':p_name' => $product_name,
            ':p_desc' => trim($_POST['product_description']) ?: null,
            ':amount' => $amount,
            ':currency' => $_POST['currency'],
            ':qty' => $quantity,
            ':expire_date' => $expire_date, // ★★★ পরিবর্তন এখানে ★★★
            ':status' => $_POST['status'] === '1' ? 1 : 0
        ]);
        
        echo json_encode(['success' => true, 'message' => 'Payment link created successfully.']);

    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
    }
} else {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method Not Allowed.']);
}
?>