<?php
header('Content-Type: application/json');
require '../db_connect.php';

// হেডার থেকে API Key দিয়ে অথেন্টিকেশন
$api_key = $_SERVER['HTTP_X_API_KEY'] ?? '';
if (empty($api_key)) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'API Key is missing.']);
    exit();
}

// API Key ব্যবহার করে user_id খুঁজে বের করা
$stmt_user = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Invalid API Key.']);
    exit();
}
$user_id = $setting['user_id'];

// ওয়ার্ডপ্রেস থেকে পাঠানো JSON ডেটা পড়া
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

$unique_payment_id = $data['unique_payment_id'] ?? null;
$order_id_wp = $data['order_id'] ?? null; // WooCommerce অর্ডার আইডি

if (empty($unique_payment_id) || empty($order_id_wp)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Payment ID and Order ID are required.']);
    exit();
}

try {
    // transactions টেবিল থেকে পেমেন্টের স্ট্যাটাস চেক করা হচ্ছে
    $stmt = $pdo->prepare("
        SELECT status, user_submitted_trxid 
        FROM transactions 
        WHERE unique_id = ? AND user_id = ?
    ");
    $stmt->execute([$unique_payment_id, $user_id]);
    $transaction = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($transaction && $transaction['status'] === 'completed') {
        // যদি স্ট্যাটাস 'completed' হয়, তাহলে সফল বার্তা পাঠানো হচ্ছে
        echo json_encode([
            'success' => true,
            'message' => 'Payment has been successfully verified.',
            'transaction_id' => $transaction['user_submitted_trxid']
        ]);
    } else {
        // যদি পেমেন্ট খুঁজে না পাওয়া যায় বা স্ট্যাটাস 'completed' না হয়
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'Payment not found or not completed.']);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error.']);
}