<?php
require 'auth_check.php';
include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">Payment Links > Create</p>
            <h1 class="page-title">Create Payment Link</h1>
        </div>
    </div>

    <div class="content-card">
        <form action="process_create_link.php" method="POST">
            <div class="form-section">
                <div class="form-row">
                    <div class="form-group half-width">
                        <label for="product_name">Product name<span class="required-star">*</span></label>
                        <input type="text" id="product_name" name="product_name" required>
                    </div>
                    <div class="form-group half-width">
                        <label for="quantity">Quantity<span class="required-star">*</span></label>
                        <input type="number" id="quantity" name="quantity" value="0" required>
                    </div>
                </div>

                <div class="form-group">
                    <label for="product_description">Product description</label>
                    <textarea id="product_description" name="product_description" rows="4"></textarea>
                </div>

                <div class="form-row">
                    <div class="form-group third-width">
                        <label for="currency">Currency</label>
                        <div class="select-wrapper">
                            <select id="currency" name="currency">
                                <option value="BDT" selected>BDT</option>
                                <option value="USD">USD</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group third-width">
                        <label for="amount">Amount<span class="required-star">*</span></label>
                        <div class="input-with-prefix">
                            <span>BDT</span>
                            <input type="number" step="0.01" id="amount" name="amount" placeholder="0.00" required>
                        </div>
                    </div>
                    <div class="form-group third-width">
                        <label for="expire_date">Expire Date</label>
                        <input type="date" id="expire_date" name="expire_date">
                    </div>
                </div>

                <div class="form-group">
                    <label>Status<span class="required-star">*</span></label>
                    <label class="toggle-switch">
                        <input type="checkbox" name="status" value="1" checked>
                        <span class="slider"></span>
                    </label>
                </div>
            </div>

            <div class="form-actions" style="border-top: 1px solid #f1f1f1; padding-top: 20px; margin-top: 20px;">
                <button type="submit" class="btn btn-primary">Save Changes</button>
                <a href="payment_links.php" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>

</div> <!-- .main-content বন্ধ করার ট্যাগ -->

<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
</body>
</html>