<?php
// ব্যবহারকারী লগইন করা আছে কিনা তা পরীক্ষা করা
require 'auth_check.php';
// ডেটাবেস সংযোগ ফাইল যুক্ত করা
require 'db_connect.php';

$sms_id = $_GET['id'] ?? null;
$user_id = $_SESSION['user_id'];

if (!$sms_id) {
    header("Location: sms_data.php");
    exit();
}

// ডেটা আপডেট করার জন্য POST রিকোয়েস্ট হ্যান্ডেল করা
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $payment_method = $_POST['payment_method'];
    $type = $_POST['type'];
    $amount = $_POST['amount'];
    $sender_number = $_POST['sender_number'];
    $transaction_id = $_POST['transaction_id'];
    $reference = $_POST['reference'];
    $note = $_POST['note'];
    $status = $_POST['status'];

    $sql = "UPDATE sms_transactions SET 
                payment_method = :payment_method, type = :type, amount = :amount, sender_number = :sender_number, 
                transaction_id = :transaction_id, reference = :reference, note = :note, status = :status
            WHERE id = :id AND user_id = :user_id";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'payment_method' => $payment_method,
        'type' => $type,
        'amount' => $amount,
        'sender_number' => $sender_number,
        'transaction_id' => $transaction_id,
        'reference' => $reference,
        'note' => $note,
        'status' => $status,
        'id' => $sms_id,
        'user_id' => $user_id
    ]);

    header("Location: sms_data.php");
    exit();
}

// ডেটাবেস থেকে বর্তমান তথ্য আনা হচ্ছে
$stmt = $pdo->prepare("SELECT * FROM sms_transactions WHERE id = ? AND user_id = ?");
$stmt->execute([$sms_id, $user_id]);
$sms = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$sms) {
    header("Location: sms_data.php");
    exit();
}

// হেডার ও সাইডবার যুক্ত করা
include 'templates/header.php';
include 'templates/sidebar.php';
?>

<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">SMS Datas > Edit</p>
            <h1 class="page-title">Edit SMS Data</h1>
        </div>
        <!-- Delete বাটন -->
        <a href="delete_sms_data.php?id=<?php echo $sms['id']; ?>" class="btn" style="background-color: #dc3545; color: white;" onclick="return confirm('Are you sure you want to delete this?');">
            <i class="fas fa-trash-alt"></i> Delete
        </a>
    </div>

    <div class="content-card">
        <form action="edit_sms_data.php?id=<?php echo $sms['id']; ?>" method="POST">
            <div class="form-grid">
                <!-- কলাম ১ -->
                <div class="form-group">
                    <label for="payment_method">Payment Method<span class="required-star">*</span></label>
                    <div class="select-wrapper">
                        <select id="payment_method" name="payment_method" required>
                            <option value="bKash" <?php echo ($sms['payment_method'] === 'bKash') ? 'selected' : ''; ?>>bKash</option>
                            <!-- প্রয়োজনে অন্যান্য অপশন যোগ করা যাবে -->
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="amount">Amount<span class="required-star">*</span></label>
                    <div class="input-with-prefix">
                        <span>BDT</span>
                        <input type="number" step="0.01" id="amount" name="amount" value="<?php echo htmlspecialchars($sms['amount']); ?>" required>
                    </div>
                </div>
                <div class="form-group">
                    <label for="transaction_id">Transaction ID<span class="required-star">*</span></label>
                    <input type="text" id="transaction_id" name="transaction_id" value="<?php echo htmlspecialchars($sms['transaction_id']); ?>" required>
                </div>
                 <div class="form-group">
                    <label for="note">Note</label>
                    <input type="text" id="note" name="note" value="<?php echo htmlspecialchars($sms['note']); ?>">
                </div>

                <!-- কলাম ২ -->
                <div class="form-group">
                    <label for="type">Type<span class="required-star">*</span></label>
                    <div class="select-wrapper">
                        <select id="type" name="type" required>
                            <option value="Personal" <?php echo ($sms['type'] === 'Personal') ? 'selected' : ''; ?>>Personal</option>
                            <option value="Agent" <?php echo ($sms['type'] === 'Agent') ? 'selected' : ''; ?>>Agent</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="sender_number">Phone Number<span class="required-star">*</span></label>
                    <input type="text" id="sender_number" name="sender_number" value="<?php echo htmlspecialchars($sms['sender_number']); ?>" required>
                </div>
                <div class="form-group">
                    <label for="reference">Reference</label>
                    <input type="text" id="reference" name="reference" value="<?php echo htmlspecialchars($sms['reference']); ?>">
                </div>
                <div class="form-group">
                    <label for="status">Status<span class="required-star">*</span></label>
                    <div class="select-wrapper">
                        <select id="status" name="status" required>
                            <option value="Received" <?php echo ($sms['status'] === 'Received') ? 'selected' : ''; ?>>Received</option>
                            <option value="Verified" <?php echo ($sms['status'] === 'Verified') ? 'selected' : ''; ?>>Verified</option>
                            <option value="Trashed" <?php echo ($sms['status'] === 'Trashed') ? 'selected' : ''; ?>>Trashed</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-actions" style="border-top: 1px solid #f1f1f1; padding-top: 20px; margin-top: 20px;">
                <button type="submit" class="btn btn-primary">Save changes</button>
                <a href="sms_data.php" class="btn btn-secondary">Back</a>
            </div>
        </form>
    </div>
</div>

</div> <!-- .main-content বন্ধ করার ট্যাগ -->

<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
</body>
</html>