<?php
/**
 * Self-Hosted Application Setup Wizard - Main Controller
 * Version: 2.2 (Robust Path & Permission Handling)
 */

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('STEPS', ['welcome', 'license', 'database', 'finish']);
$current_step = $_GET['step'] ?? 'welcome';

if ($current_step === 'license' && ($_SESSION['max_step'] ?? 'welcome') === 'welcome') {
    $_SESSION['max_step'] = 'license';
}
if (!isset($_SESSION['max_step'])) { $_SESSION['max_step'] = 'welcome'; }
$current_step_index = array_search($current_step, STEPS);
$max_step_index = array_search($_SESSION['max_step'], STEPS);
if ($current_step_index === false || $current_step_index > $max_step_index) {
    header('Location: index.php?step=' . $_SESSION['max_step']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $next_step = '';

    if ($action === 'verify_license') {
        $license_key = trim($_POST['license_key']);
        $item_name = 'taseen';
        $license_server_url = 'https://settings.top/php/api.php';
        $endpoint_key = 'YOUR_SECRET_KEY_12345';
        $error_message = 'An unknown error occurred.';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $license_server_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'endpoint_key' => $endpoint_key, 'action' => 'check', 
            'license_key' => $license_key, 'item_name' => $item_name
        ]));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curl_error = curl_error($ch);
        curl_close($ch);
        
        if ($curl_error) {
            $error_message = "API Connection Error: " . htmlspecialchars($curl_error);
        } else {
            $result = json_decode($response, true);
            if ($http_code === 200 && $result && ($result['success'] ?? false)) {
                $_SESSION['license_key'] = $license_key;
                // লাইসেন্স স্ট্যাটাস সেশনে সেভ করা হচ্ছে
                $_SESSION['license_status'] = $result['status'] ?? 'active'; 
                $_SESSION['message'] = ['type' => 'success', 'text' => 'License key is valid!'];
                $next_step = 'database';
            } else {
                $error_message = $result['message'] ?? "Verification failed (HTTP: {$http_code}).";
            }
        }

        if ($next_step !== 'database') {
            $_SESSION['message'] = ['type' => 'error', 'text' => $error_message];
            $next_step = 'license';
        }

    } elseif ($action === 'setup_database') {
        $db_host = $_POST['db_host'];
        $db_name = $_POST['db_name'];
        $db_user = $_POST['db_user'];
        $db_pass = $_POST['db_pass'];

        try {
            // ১. ডাটাবেস সংযোগ স্থাপন
            $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // ২. config.php ফাইল তৈরি
            $config_content = "<?php\n";
            $config_content .= "define('DB_HOST', '" . addslashes($db_host) . "');\n";
            $config_content .= "define('DB_NAME', '" . addslashes($db_name) . "');\n";
            $config_content .= "define('DB_USER', '" . addslashes($db_user) . "');\n";
            $config_content .= "define('DB_PASS', '" . addslashes($db_pass) . "');\n";
            $config_content .= "define('LICENSE_KEY', '" . addslashes($_SESSION['license_key']) . "');\n";
            // *** এখানেই ভার্সন নম্বরটি স্বয়ংক্রিয়ভাবে যুক্ত হচ্ছে ***
            $config_content .= "define('APP_VERSION', '1.0.0'); // Initial version\n";
            
            file_put_contents('../config.php', $config_content);

            // schema.sql ফাইল থেকে ডাটাবেস টেবিল তৈরি
            $schema_path = __DIR__ . '/schema.sql';

            if (!file_exists($schema_path)) {
                throw new Exception("CRITICAL: 'schema.sql' file does not exist at the expected path: " . htmlspecialchars($schema_path));
            }
            if (!is_readable($schema_path)) {
                throw new Exception("CRITICAL: 'schema.sql' file exists, but it is not readable. Please check the file permissions. It should be set to 644.");
            }

            $schema_sql = file_get_contents($schema_path);

            if (empty(trim($schema_sql))) {
                throw new Exception("CRITICAL: 'schema.sql' file is empty. Please ensure it contains the necessary SQL commands.");
            }

            $pdo->exec($schema_sql);
            
            $_SESSION['db_success'] = true;
            $next_step = 'finish';

        } catch (Exception $e) { // PDOException এবং সাধারণ Exception দুটোই এখানে ধরা হবে
            $_SESSION['message'] = ['type' => 'error', 'text' => 'Database Setup Failed: ' . $e->getMessage()];
            $next_step = 'database';
        }
    }

    if ($next_step) {
        $next_step_index = array_search($next_step, STEPS);
        if ($next_step_index > $max_step_index) { $_SESSION['max_step'] = $next_step; }
        header('Location: index.php?step=' . $next_step);
        exit();
    }
}

include "views/{$current_step}.php";
?>