<?php
// ব্যবহারকারী লগইন করা আছে কিনা তা পরীক্ষা করা
require 'auth_check.php';
// ডেটাবেস সংযোগ ফাইল যুক্ত করা
require 'db_connect.php'; 

// হেডার ও সাইডবার টেমপ্লেট যুক্ত করা
include 'templates/header.php';
include 'templates/sidebar.php';

$user_id = $_SESSION['user_id'];

// === ফিল্টার এবং সার্চ লজিক শুরু ===
$filter = $_GET['filter'] ?? 'all'; // URL থেকে ফিল্টার প্যারামিটার নেওয়া
$search = trim($_GET['search'] ?? ''); // URL থেকে সার্চ টার্ম নেওয়া

// is_trashed কলাম ব্যবহার করে ফিল্টার লজিক আপডেট করা হয়েছে
$sql = "SELECT id, sender_number, amount, transaction_id, status, received_at FROM sms_transactions";
$conditions = ["user_id = ?"];
$params = [$user_id];

// ট্র্যাশ ফিল্টার
if ($filter === 'trashed') {
    $conditions[] = "is_trashed = 1";
} else {
    // অন্যান্য সব ট্যাবের জন্য শুধুমাত্র is_trashed = 0 দেখানো হবে
    $conditions[] = "is_trashed = 0";
    // স্ট্যাটাস অনুযায়ী ফিল্টার
    if ($filter === 'received' || $filter === 'verified') {
        $conditions[] = "status = ?";
        $params[] = ucfirst($filter);
    }
}

// সার্চ টার্ম অনুযায়ী ফিল্টার প্রয়োগ করা
if (!empty($search)) {
    $conditions[] = "(sender_number LIKE ? OR transaction_id LIKE ?)";
    $params[] = "%{$search}%";
    $params[] = "%{$search}%";
}

// চূড়ান্ত কোয়েরি তৈরি করা
$sql .= " WHERE " . implode(' AND ', $conditions);
$sql .= " ORDER BY received_at DESC";

// কোয়েরি 실행 করা
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$sms_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
// === ফিল্টার এবং সার্চ লজিক শেষ ===
?>

<!-- SMS Data পেজের মূল কন্টেন্ট -->
<div class="page-container">
    <div class="page-header">
        <div>
            <p class="breadcrumbs">MFS > SMS Data</p>
            <h1 class="page-title">SMS Data</h1>
        </div>
        <div class="page-header-actions">
             <a href="#" id="connectAppBtn" class="btn btn-primary"><i class="fas fa-wifi"></i> Connect Android App</a>
             <a href="edit_sms_data.php" class="btn btn-primary"><i class="fas fa-plus"></i> New SMS Data</a>
        </div>
    </div>

    <div class="filter-tabs-container">
        <div class="filter-tabs">
            <a href="?filter=all&search=<?php echo urlencode($search); ?>" class="filter-tab <?php echo ($filter === 'all') ? 'active' : ''; ?>"><i class="fas fa-inbox"></i> All</a>
            <a href="?filter=received&search=<?php echo urlencode($search); ?>" class="filter-tab <?php echo ($filter === 'received') ? 'active' : ''; ?>"><i class="fas fa-clock"></i> Received</a>
            <a href="?filter=verified&search=<?php echo urlencode($search); ?>" class="filter-tab <?php echo ($filter === 'verified') ? 'active' : ''; ?>"><i class="fas fa-check-circle"></i> Verified</a>
            <a href="?filter=trashed&search=<?php echo urlencode($search); ?>" class="filter-tab <?php echo ($filter === 'trashed') ? 'active' : ''; ?>"><i class="fas fa-trash-alt"></i> Trashed</a>
        </div>
    </div>

    <div class="content-card">
        <div class="card-toolbar">
            <div class="toolbar-left"></div>
            <div class="toolbar-right">
                <form action="sms_data.php" method="GET" class="search-box">
                    <input type="hidden" name="filter" value="<?php echo htmlspecialchars($filter); ?>">
                    <i class="fas fa-search"></i>
                    <input type="text" name="search" placeholder="Search..." value="<?php echo htmlspecialchars($search); ?>">
                </form>
            </div>
        </div>

        <table class="data-table">
            <thead>
                <tr>
                    <th>Sender Number</th>
                    <th>Amount</th>
                    <th>Transaction ID</th>
                    <th>Received At</th>
                    <th>Status</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($sms_data) > 0): ?>
                    <?php foreach ($sms_data as $sms): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($sms['sender_number']); ?></td>
                            <td><?php echo htmlspecialchars($sms['amount'] ? number_format($sms['amount'], 2) . ' BDT' : 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($sms['transaction_id'] ?: 'N/A'); ?></td>
                            <td><?php echo date("d M, Y, g:i A", strtotime($sms['received_at'])); ?></td>
                            <td>
                                <span class="status-badge status-<?php echo ($sms['status'] === 'Verified') ? 'connected' : 'disconnected'; ?>">
                                    <?php echo htmlspecialchars($sms['status']); ?>
                                </span>
                            </td>
                            <td class="actions" style="text-align: right;">
                                <?php if ($filter === 'trashed'): ?>
                                    <a href="edit_sms_data.php?id=<?php echo $sms['id']; ?>" class="action-edit"><i class="fas fa-pencil-alt"></i> Edit</a>
                                    <a href="restore_sms_data.php?id=<?php echo $sms['id']; ?>" class="action-edit" style="color: #28a745;" onclick="return confirm('Are you sure you want to restore this?');"><i class="fas fa-undo"></i> Restore</a>
                                    <a href="force_delete_sms_data.php?id=<?php echo $sms['id']; ?>" class="action-delete" onclick="return confirm('This action is permanent and cannot be undone. Are you sure?');"><i class="fas fa-trash-alt"></i> Force Delete</a>
                                <?php else: ?>
                                    <a href="edit_sms_data.php?id=<?php echo $sms['id']; ?>" class="action-edit"><i class="fas fa-pencil-alt"></i> Edit</a>
                                    <a href="delete_sms_data.php?id=<?php echo $sms['id']; ?>" class="action-delete" onclick="return confirm('Are you sure you want to move this to trash?');"><i class="fas fa-trash-alt"></i> Delete</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" style="text-align:center; padding: 20px;">No matching SMS data found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div class="card-footer">
            <div class="pagination-controls">
                <span>Per page</span>
                <select>
                    <option value="10" selected>10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                </select>
            </div>
        </div>
    </div>
</div>

</div> <!-- .main-content বন্ধ করার ট্যাগ -->

<!-- Connect App সাইড প্যানেলের HTML কোড -->
<div id="connectAppPanel" class="side-panel-overlay">
    <div class="side-panel">
        <div class="side-panel-header">
            <h3>Connect Android App</h3>
            <button id="closePanelBtn" class="close-panel-btn">&times;</button>
        </div>
        <div class="side-panel-body">
            <!-- বাম কলাম: অ্যাপ ডাউনলোড -->
            <div class="panel-card">
                <div class="panel-card-header">
                    <h4>Download Android App</h4>
                    <span>&#9650;</span>
                </div>
                <div class="panel-card-body">
                    <h2>Get the Payment Automation App</h2>
                    <p class="subtitle">Only for Bangladeshi Users</p>
                    <p>Download our Android app to automate your personal payments effortlessly.</p>
                    <ul class="features-list">
                        <li><i class="fas fa-check-circle"></i> Automatically verify your transactions.</li>
                        <li><i class="fas fa-check-circle"></i> Grant necessary permissions for seamless operation.</li>
                    </ul>
                    <a href="#" class="btn btn-primary download-btn"><i class="fas fa-download"></i> Download Android App</a>
                </div>
            </div>
            <!-- ডান কলাম: QR কোড -->
            <div class="panel-card">
                 <div class="panel-card-header"><h4>Connect Android App</h4><span>&#9650;</span></div>
                <div class="panel-card-body qr-section">
                    <h4>Link Your Device</h4>
                    <p>Open the app and scan this QR code to connect.</p>
                    <div class="qr-code-container">
                        <img src="generate_qr.php" alt="Scan to connect">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="js/main.js?v=<?php echo filemtime('js/main.js'); ?>"></script>
<!-- সাইড প্যানেল নিয়ন্ত্রণের জন্য JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const connectBtn = document.getElementById('connectAppBtn');
    const closeBtn = document.getElementById('closePanelBtn');
    const panelOverlay = document.getElementById('connectAppPanel');

    if (connectBtn) {
        connectBtn.addEventListener('click', function(e) {
            e.preventDefault();
            panelOverlay.classList.add('open');
        });
    }

    if (closeBtn) {
        closeBtn.addEventListener('click', function() {
            panelOverlay.classList.remove('open');
        });
    }

    if (panelOverlay) {
        panelOverlay.addEventListener('click', function(e) {
            if (e.target === panelOverlay) {
                panelOverlay.classList.remove('open');
            }
        });
    }
});
</script>
</body>
</html>