<?php
/**
 * API Endpoint to get user_id from a provided API key.
 * This is a secure endpoint for internal communication between self-hosted instances and the central server.
 */
header('Content-Type: application/json');
require '../db_connect.php';

try {
    $api_key = $_POST['api_key'] ?? '';

    if (empty($api_key)) {
        http_response_code(400);
        throw new Exception('API key was not provided.');
    }

    $stmt = $pdo->prepare("SELECT user_id FROM settings WHERE api_key = ?");
    $stmt->execute([$api_key]);
    $setting = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($setting) {
        echo json_encode([
            'success' => true,
            'user_id' => $setting['user_id']
        ]);
    } else {
        http_response_code(403);
        throw new Exception('Invalid API key.');
    }

} catch (Exception $e) {
    $statusCode = http_response_code();
    if ($statusCode < 400) { $statusCode = 500; } // Default to 500 if not set
    http_response_code($statusCode);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>