<?php
/**
 * Create Gateway Script
 * Version 2.0 - Ensures user_id is correctly retrieved from the session.
 */

// ধাপ ১: ব্যবহারকারী লগইন করা আছে কিনা তা কঠোরভাবে পরীক্ষা করা
// auth_check.php ফাইলটি session_start() কল করে এবং $_SESSION['user_id'] আছে কিনা তা নিশ্চিত করে।
// যদি না থাকে, তাহলে এটি ব্যবহারকারীকে login.php পেজে পাঠিয়ে দেবে এবং এই স্ক্রিপ্টের বাকি অংশ আর চলবে না।
require 'auth_check.php';

// ধাপ ২: ডাটাবেস সংযোগ স্থাপন করা
require 'db_connect.php';

// ধাপ ৩: শুধুমাত্র POST মেথডের অনুরোধ গ্রহণ করা
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
    // ★★★               মূল সমাধান             ★★★
    // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
    //
    // auth_check.php দ্বারা নিশ্চিত হওয়া লগইন সেশন থেকে ব্যবহারকারীর আইডি (user_id) সংগ্রহ করা হচ্ছে।
    // এই লাইনটিই আগের কোডে অনুপস্থিত ছিল, যা NULL এরর তৈরি করছিল।
    $user_id = $_SESSION['user_id']; 
    
    // ফর্ম থেকে পাঠানো গেটওয়ের কী (key) গ্রহণ করা হচ্ছে
    $gateway_key = $_POST['gateway_key'] ?? '';

    // গেটওয়ে কী-এর উপর ভিত্তি করে একটি ডিফল্ট নাম সেট করা
    $display_name = '';
    switch ($gateway_key) {
        case 'bkash_personal':
            $display_name = 'Bkash Personal';
            break;
        case 'nagad_personal':
            $display_name = 'Nagad Personal';
            break;
        case 'rocket_personal':
            $display_name = 'Rocket Personal';
            break;
        case 'upay_personal':
            $display_name = 'Upay Personal';
            break;
        case 'bkash_merchant_tokenized':
            $display_name = 'bKash Marchant (Tokenized)';
            break;
        case 'nagad_merchant':
            $display_name = 'Nagad Marchant';
            break;
        case 'bkash_merchant_checkout':
            $display_name = 'bKash Marchant (Checkout)';
            break;
    }

    // যদি একটি বৈধ গেটওয়ে কী এবং নাম পাওয়া যায়
    if (!empty($display_name)) {
        try {
            // এখন $user_id ভ্যারিয়েবলটির একটি সঠিক মান আছে
            $sql = "INSERT INTO gateways (user_id, display_name, gateway_key) 
                    VALUES (:user_id, :display_name, :gateway_key)";
            
            $stmt = $pdo->prepare($sql);
            
            // ডাটাবেসে ডেটা ইনসার্ট করা হচ্ছে
            $stmt->execute([
                ':user_id' => $user_id, // এই ভ্যালুটি এখন আর NULL থাকবে না
                ':display_name' => $display_name,
                ':gateway_key' => $gateway_key
            ]);
        } catch (PDOException $e) {
            // যদি ডাটাবেসে কোনো সমস্যা হয়
            die("Database Error: Could not create the gateway. Details: " . $e->getMessage());
        }
    }
}

// সফলভাবে তৈরি হওয়ার পর বা কোনো ভুল অনুরোধ আসলে, ব্যবহারকারীকে পেমেন্ট গেটওয়ে পেজে ফিরিয়ে নেওয়া হবে
header("Location: payment.php");
exit();
?>