<?php
// --- এই লাইনটি আগে মিসিং ছিল, তাই এরর আসছিল ---
require_once '../config.php'; 
// ------------------------------------------------

require_once 'includes/auth_check.php';
require_once 'includes/db.php';

// এখন ডাটাবেস কানেকশন কাজ করবে কারণ config লোড করা হয়েছে
$pdo = get_db_connection();
$licenses = $pdo->query("SELECT l.*, p.item_name FROM licenses l JOIN products p ON l.product_id = p.id ORDER BY l.id DESC")->fetchAll();

include 'includes/header.php';
?>

<h1>Licenses</h1>
<p><a href="license_manage.php" class="btn btn-success">Create New License</a></p>

<table class="table table-striped table-bordered">
    <thead>
        <tr>
            <th>License Key</th>
            <th>Product</th>
            <th>Status</th>
            <th>Activations</th>
            <th>Expires</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($licenses as $license): ?>
        <tr>
            <td><code><?php echo htmlspecialchars($license['license_key']); ?></code></td>
            <td><?php echo htmlspecialchars($license['item_name']); ?></td>
            <td><span class="status-<?php echo htmlspecialchars($license['status']); ?>"><?php echo ucfirst(htmlspecialchars($license['status'])); ?></span></td>
            <td><?php echo count(json_decode($license['activations'], true) ?: []); ?> / <?php echo $license['activation_limit'] == 0 ? 'Unlimited' : $license['activation_limit']; ?></td>
            <td><?php echo $license['expires_at'] ? date('Y-m-d', strtotime($license['expires_at'])) : 'Lifetime'; ?></td>
            <td><a href="license_manage.php?id=<?php echo $license['id']; ?>" class="btn btn-sm btn-primary">Manage</a></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php include 'includes/footer.php'; ?>