<?php
// --- এই লাইনটি যুক্ত করা হয়েছে ---
require_once '../config.php';
// ---------------------------------

require_once 'includes/auth_check.php';
require_once 'includes/db.php';
require_once 'includes/functions.php';

$pdo = get_db_connection();
$pageTitle = 'Create New License';
$license = null;
$licenseId = $_GET['id'] ?? null;

if ($licenseId) {
    $pageTitle = 'Manage License';
    $stmt = $pdo->prepare("SELECT * FROM licenses WHERE id = ?");
    $stmt->execute([$licenseId]);
    $license = $stmt->fetch();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($licenseId && isset($_POST['reset_activations'])) {
        $pdo->prepare("UPDATE licenses SET activations = '[]' WHERE id = ?")->execute([$licenseId]);
    } else {
        $productId = $_POST['product_id'];
        $status = $_POST['status'];
        $activationLimit = $_POST['activation_limit'];
        $expiresAt = !empty($_POST['expires_at']) ? date('Y-m-d H:i:s', strtotime($_POST['expires_at'])) : null;

        if ($licenseId) {
            $pdo->prepare("UPDATE licenses SET product_id = ?, status = ?, activation_limit = ?, expires_at = ? WHERE id = ?")->execute([$productId, $status, $activationLimit, $expiresAt, $licenseId]);
        } else {
            $licenseKey = generate_license_key();
            $pdo->prepare("INSERT INTO licenses (license_key, product_id, status, activation_limit, expires_at) VALUES (?, ?, ?, ?, ?)")->execute([$licenseKey, $productId, $status, $activationLimit, $expiresAt]);
            $licenseId = $pdo->lastInsertId();
        }
    }
    header('Location: license_manage.php?id=' . $licenseId);
    exit;
}

$products = $pdo->query("SELECT * FROM products ORDER BY item_name ASC")->fetchAll();
$statuses = ['active', 'suspended', 'expired', 'terminated', 'inactive'];

include 'includes/header.php';
?>

<h1><?php echo $pageTitle; ?></h1>

<form method="post">
    <div class="card">
        <div class="card-body">
            <?php if ($license): ?>
            <div class="form-group">
                <label>License Key</label>
                <input type="text" class="form-control" value="<?php echo htmlspecialchars($license['license_key']); ?>" readonly>
            </div>
            <?php endif; ?>

            <div class="form-group">
                <label>Product</label>
                <select class="form-control" name="product_id" required>
                    <?php foreach ($products as $p): ?>
                    <option value="<?php echo $p['id']; ?>" <?php echo ($license && $license['product_id'] == $p['id']) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($p['item_name']); ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-row">
                <div class="form-group col-md-4">
                    <label>Status</label>
                    <select class="form-control" name="status" required>
                        <?php foreach ($statuses as $s): ?>
                        <option value="<?php echo $s; ?>" <?php echo ($license && $license['status'] == $s) ? 'selected' : ''; ?>>
                            <?php echo ucfirst($s); ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group col-md-4">
                    <label>Activation Limit (0=unlimited)</label>
                    <input type="number" class="form-control" name="activation_limit" value="<?php echo $license['activation_limit'] ?? 1; ?>" min="0" required>
                </div>
                <div class="form-group col-md-4">
                    <label>Expires At (Blank=lifetime)</label>
                    <input type="date" class="form-control" name="expires_at" value="<?php echo $license['expires_at'] ? date('Y-m-d', strtotime($license['expires_at'])) : ''; ?>">
                </div>
            </div>

            <button type="submit" class="btn btn-primary">Save Changes</button>
            <a href="index.php" class="btn btn-secondary">Back to List</a>

            <?php if ($license): ?>
            <button type="submit" name="reset_activations" class="btn btn-warning float-right" onclick="return confirm('Reset all activations?');">Reset Activations</button>
            <?php endif; ?>
        </div>
    </div>
</form>

<?php if ($license && !empty($license['activations']) && $license['activations'] !== '[]'): ?>
<div class="card mt-4">
    <div class="card-header">Activated Sites</div>
    <ul class="list-group list-group-flush">
        <?php 
        $activations_list = json_decode($license['activations'], true);
        foreach ($activations_list as $domain => $details): 
        ?>
        <li class="list-group-item"><?php echo htmlspecialchars($domain); ?></li>
        <?php endforeach; ?>
    </ul>
</div>
<?php endif; ?>

<?php include 'includes/footer.php'; ?>