<?php
// --- এই লাইনটি যুক্ত করা হয়েছে ---
require_once '../config.php';
// ---------------------------------

require_once 'includes/auth_check.php';
require_once 'includes/db.php';

$pdo = get_db_connection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_product']) && !empty(trim($_POST['item_name']))) {
        try {
            $pdo->prepare("INSERT INTO products (item_name) VALUES (?)")->execute([trim($_POST['item_name'])]);
        } catch (PDOException $e) {}
    } elseif (isset($_POST['delete_product'])) {
        $pdo->prepare("DELETE FROM products WHERE id = ?")->execute([$_POST['product_id']]);
    }
    header('Location: products.php');
    exit;
}

$products = $pdo->query("SELECT * FROM products ORDER BY item_name ASC")->fetchAll();

include 'includes/header.php';
?>

<h1>Manage Products</h1>
<p>The "Item Name" must exactly match the name sent by your client plugin.</p>

<div class="card mb-4">
    <div class="card-header">Add New Product</div>
    <div class="card-body">
        <form method="post">
            <div class="form-group">
                <label for="item_name">Product Item Name</label>
                <input type="text" class="form-control" name="item_name" required>
            </div>
            <button type="submit" name="add_product" class="btn btn-primary">Add Product</button>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">Existing Products</div>
    <ul class="list-group list-group-flush">
        <?php foreach ($products as $product): ?>
        <li class="list-group-item d-flex justify-content-between align-items-center">
            <?php echo htmlspecialchars($product['item_name']); ?>
            <form method="post" onsubmit="return confirm('Are you sure?');">
                <input type="hidden" name="product_id" value="<?php echo $product['id']; ?>">
                <button type="submit" name="delete_product" class="btn btn-sm btn-danger">Delete</button>
            </form>
        </li>
        <?php endforeach; ?>
    </ul>
</div>

<?php include 'includes/footer.php'; ?>